/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.namespace;

import io.fabric8.kubernetes.api.model.v2_6.Namespace;
import io.fabric8.kubernetes.clnt.v2_6.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_6.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_6.dsl.Resource;
import io.fabric8.openshift.api.model.v2_6.ProjectList;
import io.fabric8.openshift.api.model.v2_6.ProjectRequest;
import io.fabric8.openshift.api.model.v2_6.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.v2_6.ProjectRequestFluent;
import io.fabric8.openshift.clnt.v2_6.OpenShiftClient;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.impl.namespace.DefaultNamespaceService;

public class OpenshiftNamespaceService
extends DefaultNamespaceService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceService toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        OpenshiftNamespaceService openshiftNamespaceService = this;
        synchronized (openshiftNamespaceService) {
            if (this.delegate == null) {
                this.delegate = new ImmutableOpenshiftNamespaceService((KubernetesClient)this.client.get(), (Configuration)this.configuration.get(), (LabelProvider)((LabelProvider)this.labelProvider.get()).toImmutable(), (Logger)((Logger)this.logger.get()).toImmutable());
            }
        }
        return this.delegate;
    }

    public static class ImmutableOpenshiftNamespaceService
    extends DefaultNamespaceService.ImmutableNamespaceService {
        public ImmutableOpenshiftNamespaceService(KubernetesClient client, Configuration configuration, LabelProvider labelProvider, Logger logger) {
            super(client, configuration, labelProvider, logger);
        }

        public Namespace create(String namespace, Map<String, String> annotations) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                this.logger.status("Creating project: " + namespace);
                ProjectRequest projectRequest = ((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(namespace)).withAnnotations(annotations)).addToLabels(this.labelProvider.getLabels())).addToLabels("project", this.client.getNamespace())).addToLabels("framework", "arquillian")).addToLabels("component", "integrationTest")).endMetadata()).build();
                ProjectRequest request = (ProjectRequest)openShiftClient.projectrequests().create((Object[])new ProjectRequest[]{projectRequest});
                this.logger.info("To switch to the new project: oc project " + namespace);
                return (Namespace)((Resource)openShiftClient.namespaces().withName(request.getMetadata().getName())).get();
            }
            return super.create(namespace, annotations);
        }

        public Namespace create(String namespace) {
            return this.create(namespace, Collections.emptyMap());
        }

        public Boolean delete(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                this.logger.info("Deleting project: " + namespace + "...");
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                Boolean deleted = (Boolean)((Resource)openShiftClient.projects().withName(namespace)).delete();
                if (deleted.booleanValue()) {
                    this.logger.info("Project: " + namespace + ", successfully deleted");
                }
                return deleted;
            }
            return super.delete(namespace);
        }

        public Boolean exists(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                try {
                    return ((ProjectList)openShiftClient.projects().list()).getItems().stream().map(project -> project.getMetadata().getName()).anyMatch(Predicate.isEqual(namespace));
                }
                catch (KubernetesClientException e) {
                    return false;
                }
            }
            return super.exists(namespace);
        }

        public Namespace annotate(String namespace, Map<String, String> annotations) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                return (Namespace)((Resource)openShiftClient.namespaces().withName(namespace)).get();
            }
            return super.annotate(namespace, annotations);
        }

        @Deprecated
        public void clean(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                ((NonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(namespace)).delete();
            }
            super.clean(namespace);
        }
    }
}

