/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.api;

import java.util.HashMap;
import java.util.Map;
import org.arquillian.extension.governor.api.GovernorConfigurationException;
import org.jboss.arquillian.core.spi.Validate;

public abstract class Configuration {
    private Map<String, String> configuration = new HashMap<String, String>();

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Configuration setConfiguration(Map<String, String> configuration) {
        Validate.notNull(configuration, (String)"Properties for configuration of Arquillian Governor extension can not be a null object!");
        this.configuration = configuration;
        return this;
    }

    public String getProperty(String name, String defaultValue) throws IllegalStateException {
        Validate.notNullOrEmpty((String)name, (String)"Unable to get the configuration value of null or empty configuration key");
        Validate.notNull((Object)defaultValue, (String)("Unable to set configuration value of " + name + " to null object."));
        String found = this.getConfiguration().get(name);
        if (found == null || found.isEmpty()) {
            return defaultValue;
        }
        return found;
    }

    public void setProperty(String name, String value) {
        Validate.notNullOrEmpty((String)name, (String)"Name of property can not be a null object nor an empty string!");
        Validate.notNull((Object)value, (String)"Value of property can not be a null object!");
        this.configuration.put(name, value);
    }

    public abstract void validate() throws GovernorConfigurationException;
}

