/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.api.detector;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.extension.governor.api.detector.BaseDeciderStrategy;
import org.arquillian.extension.governor.api.detector.DeciderStrategy;
import org.arquillian.extension.governor.api.detector.Detectable;
import org.arquillian.extension.governor.api.detector.Detector;
import org.arquillian.extension.governor.utils.ReflectionUtils;

public class DetectorProcessor {
    private static final Logger logger = Logger.getLogger(DetectorProcessor.class.getName());

    public boolean process(Annotation annotation) {
        boolean detected = true;
        try {
            Detector detector = ReflectionUtils.getAnnotationProperty(annotation, "detector", Detector.class);
            DeciderStrategy strategy = detector.strategy().newInstance();
            ArrayList<Detectable> detectables = new ArrayList<Detectable>();
            for (Class<? extends Detectable> detectableClass : detector.value()) {
                detectables.add(detectableClass.newInstance());
            }
            if (strategy instanceof BaseDeciderStrategy) {
                ((BaseDeciderStrategy)strategy).detectables(detectables);
            }
            detected = strategy.resolve();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return detected;
    }
}

