/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionUtils {
    private static final Logger logger = Logger.getLogger(ReflectionUtils.class.getName());

    private ReflectionUtils() {
    }

    public static String getAnnotationValue(Annotation annotation) {
        return ReflectionUtils.getAnnotationProperty(annotation, "value", String.class);
    }

    public static <T> T getAnnotationProperty(Annotation annotation, String name, Class<T> clazz) {
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            if (!name.equals(method.getName())) continue;
            try {
                return (T)method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Invocation of method \"%s\" on annotation %s failed", name, annotation.annotationType().getName()), e);
            }
        }
        return null;
    }
}

