/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.arquillian.extension.governor.api.ClosePassedDecider;
import org.arquillian.extension.governor.api.Governor;
import org.arquillian.extension.governor.api.GovernorRegistry;
import org.arquillian.extension.governor.configuration.GovernorConfiguration;
import org.arquillian.extension.governor.impl.ClosePassedDeciderImpl;
import org.arquillian.extension.governor.impl.GovernorRegistryImpl;
import org.arquillian.extension.governor.impl.TestFramework;
import org.arquillian.extension.governor.impl.TestMethodExecutionRegister;
import org.arquillian.extension.governor.spi.GovernorProvider;
import org.arquillian.extension.governor.spi.event.DecideMethodExecutions;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class GovernorTestClassScanner {
    @Inject
    @ApplicationScoped
    private InstanceProducer<GovernorRegistry> governorRegistry;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ClosePassedDecider> closePassedDecider;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<DecideMethodExecutions> decideMethodExecution;
    @Inject
    private Instance<GovernorConfiguration> governorConfiguration;

    public void onBeforeSuite(@Observes BeforeSuite event) {
        this.closePassedDecider.set((Object)new ClosePassedDeciderImpl());
    }

    public void onBeforeClass(@Observes BeforeClass event) {
        TestMethodExecutionRegister.setConfigration((GovernorConfiguration)((Object)this.governorConfiguration.get()));
        TestMethodExecutionRegister.clear();
        if (((GovernorConfiguration)((Object)this.governorConfiguration.get())).getIgnore().booleanValue()) {
            return;
        }
        Collection governorProviders = ((ServiceLoader)this.serviceLoader.get()).all(GovernorProvider.class);
        this.checkGovernorProviderUniqueness(governorProviders);
        Map<Method, List<Annotation>> scannedTestMethods = this.scanTestMethods(event.getTestClass(), Governor.class);
        GovernorRegistryImpl governorRegistry = new GovernorRegistryImpl();
        governorRegistry.put(scannedTestMethods);
        this.governorRegistry.set((Object)governorRegistry);
        this.decideMethodExecution.fire((Object)new DecideMethodExecutions());
    }

    private void checkGovernorProviderUniqueness(Collection<GovernorProvider> governorProviders) {
        HashSet<Class> uniqueProviders = new HashSet<Class>();
        for (GovernorProvider governorProvider : governorProviders) {
            Class governorClass = governorProvider.provides();
            if (governorClass == null) {
                throw new IllegalStateException(String.format("Governor provider's provides() method (%s) returns null object.", governorProvider.getClass().getName()));
            }
            Governor governorAnnotation = governorClass.getAnnotation(Governor.class);
            if (governorAnnotation == null) {
                throw new IllegalStateException(String.format("Governor provider (%s) does not provide annotation annotated by Governor class.", governorProvider.getClass().getName()));
            }
            if (uniqueProviders.add(governorClass)) continue;
            throw new IllegalStateException(String.format("You have put on class path providers which provide the same governor annotation (%s).", governorAnnotation.annotationType()));
        }
    }

    private Map<Method, List<Annotation>> scanTestMethods(TestClass testClass, Class<? extends Annotation> governorAnnotation) {
        Method[] methods;
        Validate.notNull((Object)testClass, (String)"Test class to scan must be specified.");
        HashMap<Method, List<Annotation>> methodAnnotationsMap = new HashMap<Method, List<Annotation>>();
        Annotation[] classAnnotations = testClass.getJavaClass().getAnnotations();
        for (Method method : methods = testClass.getJavaClass().getMethods()) {
            if (!this.isTestMethod(method)) continue;
            ArrayList<Annotation> methodAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(governorAnnotation)) continue;
                methodAnnotations.add(annotation);
            }
            for (Annotation cAnnotation : classAnnotations) {
                if (!cAnnotation.annotationType().isAnnotationPresent(governorAnnotation)) continue;
                if (methodAnnotations.isEmpty()) {
                    methodAnnotations.add(cAnnotation);
                    continue;
                }
                for (Annotation mAnnotation : methodAnnotations) {
                    if (mAnnotation.annotationType().equals(cAnnotation.annotationType())) continue;
                    methodAnnotations.add(cAnnotation);
                }
            }
            if (methodAnnotations.isEmpty()) continue;
            methodAnnotationsMap.put(method, methodAnnotations);
        }
        return methodAnnotationsMap;
    }

    private boolean isTestMethod(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            for (TestFramework tf : TestFramework.values()) {
                if (!tf.getClassName().equals(annotation.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

