/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.sun.javadoc.DocErrorReporter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.asciidoclet.DocletOptions;

class AttributesLoader {
    private final Asciidoctor asciidoctor;
    private final DocletOptions docletOptions;
    private final DocErrorReporter errorReporter;

    AttributesLoader(Asciidoctor asciidoctor, DocletOptions docletOptions, DocErrorReporter errorReporter) {
        this.asciidoctor = asciidoctor;
        this.docletOptions = docletOptions;
        this.errorReporter = errorReporter;
    }

    Map<String, Object> load() {
        List<String> attributeArgs = this.docletOptions.attributes();
        Set<String> unset = this.getUnsetAttributes(attributeArgs);
        Map<String, Object> cmdlineAttrs = this.parseCmdLineAttributes(attributeArgs);
        Map<String, Object> attrs = this.parseAttributesFile(this.docletOptions.attributesFile(), cmdlineAttrs);
        attrs.keySet().removeAll(unset);
        for (String key : unset) {
            attrs.put(key + "!", "");
        }
        return attrs;
    }

    private Map<String, Object> parseCmdLineAttributes(List<String> attributeArgs) {
        return new Attributes(attributeArgs.toArray(new String[attributeArgs.size()])).map();
    }

    private Map<String, Object> parseAttributesFile(Optional<File> attrsFile, Map<String, Object> cmdlineAttrs) {
        if (attrsFile.isPresent()) {
            try {
                return this.parseAttributes(Files.newReader((File)((File)attrsFile.get()), (Charset)this.docletOptions.encoding()), cmdlineAttrs);
            }
            catch (Exception e) {
                this.errorReporter.printWarning("Cannot read attributes file: " + e);
            }
        }
        return cmdlineAttrs;
    }

    private Map<String, Object> parseAttributes(Reader in, Map<String, Object> existingAttrs) {
        OptionsBuilder options = OptionsBuilder.options().safe(SafeMode.SAFE).attributes(existingAttrs);
        if (this.docletOptions.baseDir().isPresent()) {
            options.baseDir((File)this.docletOptions.baseDir().get());
        }
        Map parsed = this.asciidoctor.readDocumentStructure(in, options.get().map()).getHeader().getAttributes();
        return new HashMap<String, Object>(parsed);
    }

    private Set<String> getUnsetAttributes(List<String> args) {
        ImmutableSet.Builder removed = ImmutableSet.builder();
        for (String arg : args) {
            String key = this.getKey(arg);
            if (!key.startsWith("!") && !key.endsWith("!")) continue;
            removed.add((Object)this.normalizeAttrName(key));
        }
        return removed.build();
    }

    private String getKey(String arg) {
        int idx = arg.indexOf(61);
        if (idx == 0) {
            throw new IllegalArgumentException("Invalid attribute arg: \"" + arg + "\"");
        }
        return idx == -1 ? arg : arg.substring(0, idx);
    }

    private String normalizeAttrName(String name) {
        return name.replaceAll("\\W", "").toLowerCase();
    }
}

