/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Frame;
import javax.swing.JDialog;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.ui.swing.BuildProgressPanel;

public class DefaultBuildProgressMonitor
extends Thread
implements IBuildProgressMonitor {
    public static final String PROGRESS_HEADING = "AspectJ Build";
    private BuildProgressPanel progressDialog = null;
    private JDialog dialog = null;

    public DefaultBuildProgressMonitor(Frame parent) {
        this.dialog = new JDialog(parent, PROGRESS_HEADING, false);
        this.progressDialog = new BuildProgressPanel();
        this.dialog.setContentPane(this.progressDialog);
        this.dialog.setSize(550, 120);
        try {
            this.dialog.setLocationRelativeTo(parent);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void begin() {
        this.progressDialog.setProgressBarVal(0);
        this.progressDialog.setProgressText("starting build...");
        this.dialog.setLocationRelativeTo(Ajde.getDefault().getRootFrame());
        this.dialog.setVisible(true);
    }

    @Override
    public void setProgressText(String text) {
        this.progressDialog.setProgressText(text);
    }

    @Override
    public void finish(boolean wasFullBuild) {
        this.progressDialog.finish();
        this.dialog.dispose();
    }

    @Override
    public boolean isCancelRequested() {
        return this.progressDialog.isCancelRequested();
    }

    @Override
    public void setProgress(double percentDone) {
        this.progressDialog.setProgressBarVal((int)(percentDone * (double)this.progressDialog.getProgressBarMax()));
    }
}

