/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Iterables;

public class ShouldContainExactly
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainExactly(Object actual, Object expected, Object notFound, Object notExpected, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainExactly(actual, expected, notFound, notExpected, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainExactly(Object actual, Object expected, Object notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy) {
        if (Iterables.isNullOrEmpty(notExpected)) {
            return new ShouldContainExactly(actual, expected, notFound, comparisonStrategy);
        }
        return new ShouldContainExactly(actual, expected, notFound, notExpected, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainExactly(Object actual, Object expected, Object notFound, Object notExpected) {
        return new ShouldContainExactly(actual, expected, notFound, notExpected, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContainExactly(Object actual, Object expected, Object notFound, Iterable<?> notExpected) {
        return ShouldContainExactly.shouldContainExactly(actual, expected, notFound, notExpected, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldContainExactly(Object actual, Object expected, Object notFound, Object notExpected, ComparisonStrategy comparisonStrategy) {
        super("\nExpecting:\n  <%s>\nto contain exactly (and in same order):\n  <%s>\nbut some elements were not found:\n  <%s>\nand others were not expected:\n  <%s>\n%s", actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, Object notFound, ComparisonStrategy comparisonStrategy) {
        super("\nExpecting:\n  <%s>\nto contain exactly (and in same order):\n  <%s>\nbut could not find the following elements:\n  <%s>\n%s", actual, expected, notFound, comparisonStrategy);
    }

    public static ErrorMessageFactory elementsDifferAtIndex(Object actualElement, Object expectedElement, int indexOfDifferentElements, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainExactly(actualElement, expectedElement, indexOfDifferentElements, comparisonStrategy);
    }

    public static ErrorMessageFactory elementsDifferAtIndex(Object actualElement, Object expectedElement, int indexOfDifferentElements) {
        return new ShouldContainExactly(actualElement, expectedElement, indexOfDifferentElements, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldContainExactly(Object actualElement, Object expectedElement, int indexOfDifferentElements, ComparisonStrategy comparisonStrategy) {
        super("\nActual and expected have the same elements but not in the same order, at index %s actual element was:\n  <%s>\nwhereas expected element was:\n  <%s>\n%s", indexOfDifferentElements, actualElement, expectedElement, comparisonStrategy);
    }
}

