/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.build;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.ClassFileVersion;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.dynamic.ClassFileLocator;
import org.assertj.core.internal.bytebuddy.dynamic.DynamicType;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;

public interface EntryPoint {
    public ByteBuddy byteBuddy(ClassFileVersion var1);

    public DynamicType.Builder<?> transform(TypeDescription var1, ByteBuddy var2, ClassFileLocator var3, MethodNameTransformer var4);

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="An enumeration does not serialize fields")
    public static enum Default implements EntryPoint
    {
        REBASE{

            @Override
            public ByteBuddy byteBuddy(ClassFileVersion classFileVersion) {
                return new ByteBuddy(classFileVersion);
            }

            @Override
            public DynamicType.Builder<?> transform(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                return byteBuddy.rebase(typeDescription, classFileLocator, methodNameTransformer);
            }
        }
        ,
        REDEFINE{

            @Override
            public ByteBuddy byteBuddy(ClassFileVersion classFileVersion) {
                return new ByteBuddy(classFileVersion);
            }

            @Override
            public DynamicType.Builder<?> transform(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                return byteBuddy.redefine(typeDescription, classFileLocator);
            }
        }
        ,
        REDEFINE_LOCAL{

            @Override
            public ByteBuddy byteBuddy(ClassFileVersion classFileVersion) {
                return new ByteBuddy(classFileVersion).with(Implementation.Context.Disabled.Factory.INSTANCE);
            }

            @Override
            public DynamicType.Builder<?> transform(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                return byteBuddy.redefine(typeDescription, classFileLocator).ignoreAlso(ElementMatchers.not(ElementMatchers.isDeclaredBy(typeDescription)));
            }
        };

    }
}

