/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Date;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.DateUtil;

public class ShouldBeAfter
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeAfter(Object actual, Object other, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeAfter(actual, other, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldBeAfter(Object actual, Object other) {
        return new ShouldBeAfter(actual, other, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldBeAfter(Date actual, int year) {
        Date januaryTheFirstOfGivenYear = DateUtil.parse(year + "-01-01");
        return new ShouldBeAfter(actual, (Object)januaryTheFirstOfGivenYear, StandardComparisonStrategy.instance());
    }

    private ShouldBeAfter(Object actual, Object other, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting:%n  <%s>%nto be strictly after:%n  <%s>%n%s", actual, other, comparisonStrategy);
    }
}

