/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.ComparisonKeyDifference;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.DualValueDeque;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class RecursiveComparisonDifferenceCalculator {
    private static final String DIFFERENT_ACTUAL_AND_EXPECTED_FIELD_TYPES = "expected field is %s but actual field is not (%s)";
    private static final String ACTUAL_NOT_ORDERED_COLLECTION = "expected field is an ordered collection but actual field is not (%s), ordered collections are: " + RecursiveComparisonDifferenceCalculator.describeOrderedCollectionTypes();
    private static final String VALUE_FIELD_NAME = "value";
    private static final String ARRAY_FIELD_NAME = "array";
    private static final String STRICT_TYPE_ERROR = "the fields are considered different since the comparison enforces strict type check and %s is not a subtype of %s";
    private static final String DIFFERENT_SIZE_ERROR = "actual and expected values are %s of different size, actual size=%s when expected size=%s";
    private static final String MISSING_FIELDS = "%s can't be compared to %s as %s does not declare all %s fields, it lacks these: %s";
    private static final Map<Class<?>, Boolean> customEquals = new ConcurrentHashMap();

    public List<ComparisonDifference> determineDifferences(Object actual, Object expected, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(actual, expected)) {
            return Lists.list(RecursiveComparisonDifferenceCalculator.expectedAndActualTypeDifference(actual, expected));
        }
        List<DualValue> visited = Lists.list(new DualValue[0]);
        return RecursiveComparisonDifferenceCalculator.determineDifferences(actual, expected, FieldLocation.rootFieldLocation(), visited, recursiveComparisonConfiguration);
    }

    private static List<ComparisonDifference> determineDifferences(Object actual, Object expected, FieldLocation fieldLocation, List<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        ComparisonState comparisonState = new ComparisonState(visited, recursiveComparisonConfiguration);
        comparisonState.initDualValuesToCompare(actual, expected, fieldLocation);
        while (comparisonState.hasDualValuesToCompare()) {
            DualValue dualValue = comparisonState.pickDualValueToCompare();
            Object actualFieldValue = dualValue.actual;
            Object expectedFieldValue = dualValue.expected;
            if (recursiveComparisonConfiguration.hasCustomComparator(dualValue)) {
                if (RecursiveComparisonDifferenceCalculator.areDualValueEqual(dualValue, recursiveComparisonConfiguration)) continue;
                comparisonState.addDifference(dualValue);
                continue;
            }
            if (actualFieldValue == expectedFieldValue) continue;
            if (actualFieldValue == null || expectedFieldValue == null) {
                comparisonState.addDifference(dualValue);
                continue;
            }
            if (dualValue.isExpectedAnEnum()) {
                RecursiveComparisonDifferenceCalculator.compareAsEnums(dualValue, comparisonState, recursiveComparisonConfiguration);
                continue;
            }
            if (dualValue.isExpectedFieldAnArray()) {
                RecursiveComparisonDifferenceCalculator.compareArrays(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnOrderedCollection() && !recursiveComparisonConfiguration.shouldIgnoreCollectionOrder(dualValue.fieldLocation)) {
                RecursiveComparisonDifferenceCalculator.compareOrderedCollections(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnIterable()) {
                RecursiveComparisonDifferenceCalculator.compareUnorderedIterables(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnOptional()) {
                RecursiveComparisonDifferenceCalculator.compareOptional(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldASortedMap()) {
                RecursiveComparisonDifferenceCalculator.compareSortedMap(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAMap()) {
                RecursiveComparisonDifferenceCalculator.compareUnorderedMap(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicBoolean()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicBoolean(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicInteger()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicInteger(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicIntegerArray()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicIntegerArray(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicLong()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicLong(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicLongArray()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicLongArray(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicReference()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicReference(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnAtomicReferenceArray()) {
                RecursiveComparisonDifferenceCalculator.compareAtomicReferenceArray(dualValue, comparisonState);
                continue;
            }
            if (RecursiveComparisonDifferenceCalculator.shouldHonorEquals(dualValue, recursiveComparisonConfiguration)) {
                if (actualFieldValue.equals(expectedFieldValue)) continue;
                comparisonState.addDifference(dualValue);
                continue;
            }
            Class<?> actualFieldValueClass = actualFieldValue.getClass();
            Class<?> expectedFieldClass = expectedFieldValue.getClass();
            if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualValue)) {
                comparisonState.addDifference(dualValue, String.format(STRICT_TYPE_ERROR, expectedFieldClass.getName(), actualFieldValueClass.getName()));
                continue;
            }
            Set<String> actualNonIgnoredFieldsNames = recursiveComparisonConfiguration.getActualFieldNamesToCompare(dualValue);
            Set<String> expectedFieldsNames = Objects.getFieldsNames(expectedFieldClass);
            if (!expectedFieldsNames.containsAll(actualNonIgnoredFieldsNames)) {
                HashSet<String> actualFieldsNamesNotInExpected = Sets.newHashSet(actualNonIgnoredFieldsNames);
                actualFieldsNamesNotInExpected.removeAll(expectedFieldsNames);
                String missingFields = ((Object)actualFieldsNamesNotInExpected).toString();
                String expectedClassName = expectedFieldClass.getName();
                String actualClassName = actualFieldValueClass.getName();
                String missingFieldsDescription = String.format(MISSING_FIELDS, actualClassName, expectedClassName, expectedFieldClass.getSimpleName(), actualFieldValueClass.getSimpleName(), missingFields);
                comparisonState.addDifference(dualValue, missingFieldsDescription);
                continue;
            }
            for (String actualFieldName : actualNonIgnoredFieldsNames) {
                if (!expectedFieldsNames.contains(actualFieldName)) continue;
                DualValue newDualValue = new DualValue(dualValue.fieldLocation.field(actualFieldName), PropertyOrFieldSupport.COMPARISON.getSimpleValue(actualFieldName, actualFieldValue), PropertyOrFieldSupport.COMPARISON.getSimpleValue(actualFieldName, expectedFieldValue));
                comparisonState.registerForComparison(newDualValue);
            }
        }
        return comparisonState.getDifferences();
    }

    private static void compareAsEnums(DualValue dualValue, ComparisonState comparisonState, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode()) {
            if (dualValue.actual != dualValue.expected) {
                comparisonState.addDifference(dualValue);
            }
            return;
        }
        if (!dualValue.isActualAnEnum()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an enum"));
            return;
        }
        Enum actualEnum = (Enum)dualValue.actual;
        Enum expectedEnum = (Enum)dualValue.expected;
        if (!actualEnum.name().equals(expectedEnum.name())) {
            comparisonState.addDifference(dualValue);
        }
    }

    private static boolean shouldHonorEquals(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        boolean shouldHonorJavaTypeEquals = dualValue.hasSomeJavaTypeValue() && !dualValue.isExpectedAContainer();
        return shouldHonorJavaTypeEquals || RecursiveComparisonDifferenceCalculator.shouldHonorOverriddenEquals(dualValue, recursiveComparisonConfiguration);
    }

    private static boolean shouldHonorOverriddenEquals(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        boolean shouldNotIgnoreOverriddenEqualsIfAny = !recursiveComparisonConfiguration.shouldIgnoreOverriddenEqualsOf(dualValue);
        return shouldNotIgnoreOverriddenEqualsIfAny && dualValue.actual != null && RecursiveComparisonDifferenceCalculator.hasOverriddenEquals(dualValue.actual.getClass());
    }

    private static void compareArrays(DualValue dualValue, ComparisonState comparisonState) {
        int expectedArrayLength;
        if (!dualValue.isActualFieldAnArray()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an array"));
            return;
        }
        int actualArrayLength = Array.getLength(dualValue.actual);
        if (actualArrayLength != (expectedArrayLength = Array.getLength(dualValue.expected))) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "arrays", actualArrayLength, expectedArrayLength));
            return;
        }
        FieldLocation arrayFieldLocation = dualValue.fieldLocation;
        for (int i = 0; i < actualArrayLength; ++i) {
            Object actualElement = Array.get(dualValue.actual, i);
            Object expectedElement = Array.get(dualValue.expected, i);
            FieldLocation elementFieldLocation = arrayFieldLocation.field(String.format("[%d]", i));
            comparisonState.registerForComparison(new DualValue(elementFieldLocation, actualElement, expectedElement));
        }
    }

    private static void compareOrderedCollections(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnOrderedCollection()) {
            comparisonState.addDifference(dualValue, String.format(ACTUAL_NOT_ORDERED_COLLECTION, dualValue.actual.getClass().getCanonicalName()));
            return;
        }
        Collection actualCollection = (Collection)dualValue.actual;
        Collection expectedCollection = (Collection)dualValue.expected;
        if (actualCollection.size() != expectedCollection.size()) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "collections", actualCollection.size(), expectedCollection.size()));
            return;
        }
        Iterator expectedIterator = expectedCollection.iterator();
        int i = 0;
        for (Object element : actualCollection) {
            FieldLocation elementFielLocation = dualValue.fieldLocation.field(String.format("[%d]", i));
            DualValue elementDualValue = new DualValue(elementFielLocation, element, expectedIterator.next());
            comparisonState.registerForComparison(elementDualValue);
            ++i;
        }
    }

    private static String differentTypeErrorMessage(DualValue dualValue, String actualTypeDescription) {
        return String.format(DIFFERENT_ACTUAL_AND_EXPECTED_FIELD_TYPES, actualTypeDescription, dualValue.actual.getClass().getCanonicalName());
    }

    private static void compareUnorderedIterables(DualValue dualValue, ComparisonState comparisonState) {
        int expectedSize;
        if (!dualValue.isActualFieldAnIterable()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an iterable"));
            return;
        }
        Iterable actual = (Iterable)dualValue.actual;
        Iterable expected = (Iterable)dualValue.expected;
        int actualSize = IterableUtil.sizeOf(actual);
        if (actualSize != (expectedSize = IterableUtil.sizeOf(expected))) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "collections", actualSize, expectedSize));
            return;
        }
        LinkedList actualCopy = new LinkedList(IterableUtil.toCollection(actual));
        List<Object> expectedElementsNotFound = Lists.list(new Object[0]);
        for (Object expectedElement : expected) {
            boolean expectedElementMatched = false;
            Iterator actualIterator = actualCopy.iterator();
            while (actualIterator.hasNext()) {
                Object actualElement = actualIterator.next();
                List<ComparisonDifference> differences = RecursiveComparisonDifferenceCalculator.determineDifferences(actualElement, expectedElement, dualValue.fieldLocation, comparisonState.visitedDualValues, comparisonState.recursiveComparisonConfiguration);
                if (!differences.isEmpty()) continue;
                actualIterator.remove();
                expectedElementMatched = true;
                break;
            }
            if (expectedElementMatched) continue;
            expectedElementsNotFound.add(expectedElement);
        }
        if (!expectedElementsNotFound.isEmpty()) {
            String unmatched = String.format("The following expected elements were not matched in the actual %s:%n  %s", actual.getClass().getSimpleName(), expectedElementsNotFound);
            comparisonState.addDifference(dualValue, unmatched);
        }
    }

    private static <K, V> void compareSortedMap(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldASortedMap()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "a sorted map"));
            return;
        }
        Map actualMap = (Map)dualValue.actual;
        Map expectedMap = (Map)dualValue.expected;
        if (actualMap.size() != expectedMap.size()) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "sorted maps", actualMap.size(), expectedMap.size()));
            return;
        }
        Iterator expectedMapEntries = expectedMap.entrySet().iterator();
        for (Map.Entry actualEntry : actualMap.entrySet()) {
            Map.Entry expectedEntry = expectedMapEntries.next();
            if (!java.util.Objects.equals(actualEntry.getKey(), expectedEntry.getKey())) {
                comparisonState.addKeyDifference(dualValue, actualEntry.getKey(), expectedEntry.getKey());
                continue;
            }
            FieldLocation keyFieldLocation = RecursiveComparisonDifferenceCalculator.keyFieldLocation(dualValue.fieldLocation, actualEntry.getKey());
            comparisonState.registerForComparison(new DualValue(keyFieldLocation, actualEntry.getValue(), expectedEntry.getValue()));
        }
    }

    private static void compareUnorderedMap(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAMap()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "a map"));
            return;
        }
        Map actualMap = (Map)dualValue.actual;
        Map expectedMap = (Map)dualValue.expected;
        if (actualMap.size() != expectedMap.size()) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "maps", actualMap.size(), expectedMap.size()));
            return;
        }
        LinkedHashSet expectedKeysNotFound = new LinkedHashSet(expectedMap.keySet());
        expectedKeysNotFound.removeAll(actualMap.keySet());
        if (!expectedKeysNotFound.isEmpty()) {
            comparisonState.addDifference(dualValue, String.format("The following keys were not found in the actual map value:%n  %s", expectedKeysNotFound));
            return;
        }
        for (Object key : expectedMap.keySet()) {
            FieldLocation keyFieldLocation = RecursiveComparisonDifferenceCalculator.keyFieldLocation(dualValue.fieldLocation, key);
            comparisonState.registerForComparison(new DualValue(keyFieldLocation, actualMap.get(key), expectedMap.get(key)));
        }
    }

    private static FieldLocation keyFieldLocation(FieldLocation parentFieldLocation, Object key) {
        return key == null ? parentFieldLocation : parentFieldLocation.field(key.toString());
    }

    private static void compareOptional(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnOptional()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an Optional"));
            return;
        }
        Optional actual = (Optional)dualValue.actual;
        Optional expected = (Optional)dualValue.expected;
        if (actual.isPresent() != expected.isPresent()) {
            comparisonState.addDifference(dualValue);
            return;
        }
        if (!actual.isPresent()) {
            return;
        }
        Object value1 = actual.get();
        Object value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.fieldLocation.field(VALUE_FIELD_NAME), value1, value2));
    }

    private static void compareAtomicBoolean(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnAtomicBoolean()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicBoolean"));
            return;
        }
        AtomicBoolean actual = (AtomicBoolean)dualValue.actual;
        AtomicBoolean expected = (AtomicBoolean)dualValue.expected;
        Boolean value1 = actual.get();
        Boolean value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.fieldLocation.field(VALUE_FIELD_NAME), (Object)value1, (Object)value2));
    }

    private static void compareAtomicInteger(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnAtomicInteger()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicInteger"));
            return;
        }
        AtomicInteger actual = (AtomicInteger)dualValue.actual;
        AtomicInteger expected = (AtomicInteger)dualValue.expected;
        Integer value1 = actual.get();
        Integer value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.fieldLocation.field(VALUE_FIELD_NAME), (Object)value1, (Object)value2));
    }

    private static void compareAtomicIntegerArray(DualValue dualValue, ComparisonState comparisonState) {
        int expectedArrayLength;
        if (!dualValue.isActualFieldAnAtomicIntegerArray()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicIntegerArray"));
            return;
        }
        AtomicIntegerArray actual = (AtomicIntegerArray)dualValue.actual;
        AtomicIntegerArray expected = (AtomicIntegerArray)dualValue.expected;
        int actualArrayLength = actual.length();
        if (actualArrayLength != (expectedArrayLength = expected.length())) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "AtomicIntegerArrays", actualArrayLength, expectedArrayLength));
            return;
        }
        FieldLocation arrayFieldLocation = dualValue.fieldLocation;
        for (int i = 0; i < actualArrayLength; ++i) {
            Integer actualElement = actual.get(i);
            Integer expectedElement = expected.get(i);
            FieldLocation elementFieldLocation = arrayFieldLocation.field(String.format("array[%d]", i));
            comparisonState.registerForComparison(new DualValue(elementFieldLocation, (Object)actualElement, (Object)expectedElement));
        }
    }

    private static void compareAtomicLong(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnAtomicLong()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicLong"));
            return;
        }
        AtomicLong actual = (AtomicLong)dualValue.actual;
        AtomicLong expected = (AtomicLong)dualValue.expected;
        Long value1 = actual.get();
        Long value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.fieldLocation.field(VALUE_FIELD_NAME), (Object)value1, (Object)value2));
    }

    private static void compareAtomicLongArray(DualValue dualValue, ComparisonState comparisonState) {
        int expectedArrayLength;
        if (!dualValue.isActualFieldAnAtomicLongArray()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicLongArray"));
            return;
        }
        AtomicLongArray actual = (AtomicLongArray)dualValue.actual;
        AtomicLongArray expected = (AtomicLongArray)dualValue.expected;
        int actualArrayLength = actual.length();
        if (actualArrayLength != (expectedArrayLength = expected.length())) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "AtomicLongArrays", actualArrayLength, expectedArrayLength));
            return;
        }
        FieldLocation arrayFieldLocation = dualValue.fieldLocation;
        for (int i = 0; i < actualArrayLength; ++i) {
            Long actualElement = actual.get(i);
            Long expectedElement = expected.get(i);
            FieldLocation elementFieldLocation = arrayFieldLocation.field(String.format("array[%d]", i));
            comparisonState.registerForComparison(new DualValue(elementFieldLocation, (Object)actualElement, (Object)expectedElement));
        }
    }

    private static void compareAtomicReferenceArray(DualValue dualValue, ComparisonState comparisonState) {
        int expectedArrayLength;
        if (!dualValue.isActualFieldAnAtomicReferenceArray()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicReferenceArray"));
            return;
        }
        AtomicReferenceArray actual = (AtomicReferenceArray)dualValue.actual;
        AtomicReferenceArray expected = (AtomicReferenceArray)dualValue.expected;
        int actualArrayLength = actual.length();
        if (actualArrayLength != (expectedArrayLength = expected.length())) {
            comparisonState.addDifference(dualValue, String.format(DIFFERENT_SIZE_ERROR, "AtomicReferenceArrays", actualArrayLength, expectedArrayLength));
            return;
        }
        FieldLocation arrayFieldLocation = dualValue.fieldLocation;
        for (int i = 0; i < actualArrayLength; ++i) {
            Object actualElement = actual.get(i);
            Object expectedElement = expected.get(i);
            FieldLocation elementFieldLocation = arrayFieldLocation.field(String.format("array[%d]", i));
            comparisonState.registerForComparison(new DualValue(elementFieldLocation, actualElement, expectedElement));
        }
    }

    private static void compareAtomicReference(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnAtomicReference()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an AtomicReference"));
            return;
        }
        AtomicReference actual = (AtomicReference)dualValue.actual;
        AtomicReference expected = (AtomicReference)dualValue.expected;
        Object value1 = actual.get();
        Object value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.fieldLocation.field(VALUE_FIELD_NAME), value1, value2));
    }

    static boolean hasOverriddenEquals(Class<?> c) {
        if (customEquals.containsKey(c)) {
            return customEquals.get(c);
        }
        Class<?> origClass = c;
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customEquals.put(origClass, false);
        return false;
    }

    private static boolean areDualValueEqual(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        String fieldName = dualValue.getConcatenatedPath();
        Object actualFieldValue = dualValue.actual;
        Object expectedFieldValue = dualValue.expected;
        Comparator<Object> fieldComparator = recursiveComparisonConfiguration.getComparatorForField(fieldName);
        if (fieldComparator != null) {
            return RecursiveComparisonDifferenceCalculator.areEqualUsingComparator(actualFieldValue, expectedFieldValue, fieldComparator);
        }
        Class<?> fieldType = actualFieldValue != null ? actualFieldValue.getClass() : expectedFieldValue.getClass();
        Comparator<Object> typeComparator = recursiveComparisonConfiguration.getComparatorForType(fieldType);
        if (typeComparator != null) {
            return RecursiveComparisonDifferenceCalculator.areEqualUsingComparator(actualFieldValue, expectedFieldValue, typeComparator);
        }
        return java.util.Objects.deepEquals(actualFieldValue, expectedFieldValue);
    }

    private static boolean areEqualUsingComparator(Object actual, Object expected, Comparator<Object> comparator) {
        try {
            return comparator.compare(actual, expected) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static ComparisonDifference expectedAndActualTypeDifference(Object actual, Object expected) {
        String additionalInformation = String.format("actual and expected are considered different since the comparison enforces strict type check and expected type %s is not a subtype of actual type %s", expected.getClass().getName(), actual.getClass().getName());
        return ComparisonDifference.rootComparisonDifference(actual, expected, additionalInformation);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(DualValue dualField) {
        return RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualField.actual, dualField.expected);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(Object actual, Object expected) {
        return !actual.getClass().isAssignableFrom(expected.getClass());
    }

    private static String describeOrderedCollectionTypes() {
        return Stream.of(DualValue.DEFAULT_ORDERED_COLLECTION_TYPES).map(Class::getName).collect(Collectors.joining(", ", "[", "]"));
    }

    private static class ComparisonState {
        List<DualValue> visitedDualValues;
        List<ComparisonDifference> differences = new ArrayList<ComparisonDifference>();
        DualValueDeque dualValuesToCompare;
        RecursiveComparisonConfiguration recursiveComparisonConfiguration;

        public ComparisonState(List<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
            this.visitedDualValues = visited;
            this.dualValuesToCompare = new DualValueDeque(recursiveComparisonConfiguration);
            this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
        }

        void addDifference(DualValue dualValue) {
            this.differences.add(new ComparisonDifference(dualValue, null, this.getCustomErrorMessage(dualValue)));
        }

        void addDifference(DualValue dualValue, String description) {
            this.differences.add(new ComparisonDifference(dualValue, description, this.getCustomErrorMessage(dualValue)));
        }

        void addKeyDifference(DualValue parentDualValue, Object actualKey, Object expectedKey) {
            this.differences.add(new ComparisonKeyDifference(parentDualValue, actualKey, expectedKey));
        }

        public List<ComparisonDifference> getDifferences() {
            Collections.sort(this.differences);
            return this.differences;
        }

        public boolean hasDualValuesToCompare() {
            return !this.dualValuesToCompare.isEmpty();
        }

        public DualValue pickDualValueToCompare() {
            DualValue dualValue = (DualValue)this.dualValuesToCompare.removeFirst();
            if (dualValue.hasPotentialCyclingValues()) {
                this.visitedDualValues.add(dualValue);
            }
            return dualValue;
        }

        private void registerForComparison(DualValue dualValue) {
            if (!this.visitedDualValues.contains(dualValue)) {
                this.dualValuesToCompare.addFirst(dualValue);
            }
        }

        private void initDualValuesToCompare(Object actual, Object expected, FieldLocation fieldLocation) {
            DualValue dualValue = new DualValue(fieldLocation, actual, expected);
            boolean mustCompareFieldsRecursively = this.mustCompareFieldsRecursively(dualValue);
            if (dualValue.hasNoNullValues() && mustCompareFieldsRecursively) {
                Set<String> actualFieldNamesToCompare = this.recursiveComparisonConfiguration.getActualFieldNamesToCompare(dualValue);
                if (!actualFieldNamesToCompare.isEmpty()) {
                    Set<String> expectedFieldsNames = Objects.getFieldsNames(expected.getClass());
                    if (expectedFieldsNames.containsAll(actualFieldNamesToCompare)) {
                        for (String nonIgnoredActualFieldName : actualFieldNamesToCompare) {
                            DualValue fieldDualValue = new DualValue(fieldLocation.field(nonIgnoredActualFieldName), PropertyOrFieldSupport.COMPARISON.getSimpleValue(nonIgnoredActualFieldName, actual), PropertyOrFieldSupport.COMPARISON.getSimpleValue(nonIgnoredActualFieldName, expected));
                            this.dualValuesToCompare.addFirst(fieldDualValue);
                        }
                    } else {
                        this.dualValuesToCompare.addFirst(dualValue);
                    }
                } else {
                    this.dualValuesToCompare.addFirst(dualValue);
                }
            } else {
                this.dualValuesToCompare.addFirst(dualValue);
            }
            this.visitedDualValues.forEach(visitedDualValue -> this.dualValuesToCompare.stream().filter(dualValueToCompare -> dualValueToCompare.equals(visitedDualValue)).findFirst().ifPresent(this.dualValuesToCompare::remove));
        }

        private boolean mustCompareFieldsRecursively(DualValue dualValue) {
            return !this.recursiveComparisonConfiguration.hasCustomComparator(dualValue) && !RecursiveComparisonDifferenceCalculator.shouldHonorEquals(dualValue, this.recursiveComparisonConfiguration) && dualValue.hasNoContainerValues();
        }

        private String getCustomErrorMessage(DualValue dualValue) {
            Class<?> fieldType;
            String fieldName = dualValue.getConcatenatedPath();
            if (this.recursiveComparisonConfiguration.hasCustomMessageForField(fieldName)) {
                return this.recursiveComparisonConfiguration.getMessageForField(fieldName);
            }
            Class<?> clazz = fieldType = dualValue.actual != null ? dualValue.actual.getClass() : dualValue.expected.getClass();
            if (this.recursiveComparisonConfiguration.hasCustomMessageForType(fieldType)) {
                return this.recursiveComparisonConfiguration.getMessageForType(fieldType);
            }
            return null;
        }
    }
}

