/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.Comparator;

public class DoubleComparator
implements Comparator<Double> {
    private double epsilon;

    public DoubleComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public int compare(Double x, Double y) {
        if (DoubleComparator.closeEnough(x, y, this.epsilon)) {
            return 0;
        }
        return x < y ? -1 : 1;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    private static boolean complexCloseEnough(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || diff < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Double.MAX_VALUE) < epsilon;
    }

    private static boolean closeEnough(double a, double b, double epsilon) {
        return a == b || Math.abs(a - b) < epsilon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.epsilon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleComparator)) {
            return false;
        }
        DoubleComparator other = (DoubleComparator)obj;
        return Double.doubleToLongBits(this.epsilon) == Double.doubleToLongBits(other.epsilon);
    }
}

