/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.SoftAssertionError;
import org.assertj.core.description.Description;
import org.assertj.core.error.ConstructorInvoker;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.error.MultipleAssertionsError;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.UnambiguousRepresentation;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Throwables;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class AssertionErrorCreator {
    private static final Class<?>[] MSG_ARG_TYPES_FOR_ASSERTION_FAILED_ERROR = Arrays.array(String.class, Object.class, Object.class);
    private static final Class<?>[] MSG_ARG_TYPES_FOR_COMPARISON_FAILURE = Arrays.array(String.class, String.class, String.class);
    private static final Class<?>[] MULTIPLE_FAILURES_ERROR_ARGUMENT_TYPES = Arrays.array(String.class, List.class);
    ConstructorInvoker constructorInvoker;

    public AssertionErrorCreator() {
        this(new ConstructorInvoker());
    }

    public AssertionErrorCreator(ConstructorInvoker constructorInvoker) {
        this.constructorInvoker = constructorInvoker;
    }

    public AssertionError assertionError(String message, Object actual, Object expected, Representation representation) {
        return this.assertionFailedError(message, actual, expected).orElse(this.comparisonFailure(message, actual, expected, representation).orElse(this.assertionError(message)));
    }

    private Optional<AssertionError> assertionFailedError(String message, Object actual, Object expected) {
        try {
            Object o = this.constructorInvoker.newInstance("org.opentest4j.AssertionFailedError", MSG_ARG_TYPES_FOR_ASSERTION_FAILED_ERROR, message, expected, actual);
            if (o instanceof AssertionError) {
                AssertionError error = (AssertionError)o;
                return Optional.of(error);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    private Optional<AssertionError> comparisonFailure(String message, Object actual, Object expected, Representation representation) {
        try {
            UnambiguousRepresentation unambiguousRepresentation = new UnambiguousRepresentation(representation, actual, expected);
            Object o = this.constructorInvoker.newInstance("org.junit.ComparisonFailure", MSG_ARG_TYPES_FOR_COMPARISON_FAILURE, message, unambiguousRepresentation.getExpected(), unambiguousRepresentation.getActual());
            if (o instanceof AssertionError) {
                AssertionError error = (AssertionError)o;
                return Optional.of(error);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    public AssertionError assertionError(String message) {
        return new AssertionError((Object)message);
    }

    public AssertionError multipleSoftAssertionsError(List<? extends Throwable> errors) {
        Optional<AssertionError> multipleFailuresError = this.tryBuildingMultipleFailuresError(errors);
        return multipleFailuresError.orElse(new SoftAssertionError(Throwables.describeErrors(errors)));
    }

    public AssertionError multipleAssertionsError(Description description, List<? extends AssertionError> errors) {
        String heading = AssertionErrorCreator.headingFrom(description);
        Optional<AssertionError> multipleFailuresError = this.tryBuildingMultipleFailuresError(heading, errors);
        return multipleFailuresError.orElse(new MultipleAssertionsError(description, errors));
    }

    public void tryThrowingMultipleFailuresError(List<? extends Throwable> errorsCollected) {
        this.tryBuildingMultipleFailuresError(errorsCollected).ifPresent(AssertionErrorCreator::throwError);
    }

    private static void throwError(AssertionError error) {
        throw error;
    }

    private static String headingFrom(Description description) {
        return description == null ? null : DescriptionFormatter.instance().format(description);
    }

    private Optional<AssertionError> tryBuildingMultipleFailuresError(List<? extends Throwable> errorsCollected) {
        return this.tryBuildingMultipleFailuresError(null, errorsCollected);
    }

    private Optional<AssertionError> tryBuildingMultipleFailuresError(String heading, List<? extends Throwable> errorsCollected) {
        if (errorsCollected.isEmpty()) {
            return Optional.empty();
        }
        try {
            Object[] constructorArguments = Arrays.array(heading, errorsCollected);
            Object multipleFailuresError = this.constructorInvoker.newInstance("org.opentest4j.MultipleFailuresError", MULTIPLE_FAILURES_ERROR_ARGUMENT_TYPES, constructorArguments);
            if (multipleFailuresError instanceof AssertionError) {
                List<Throwable> failures = AssertionErrorCreator.extractFailuresOf(multipleFailuresError);
                AssertionError assertionError = (AssertionError)this.constructorInvoker.newInstance("org.assertj.core.error.AssertJMultipleFailuresError", MULTIPLE_FAILURES_ERROR_ARGUMENT_TYPES, Arrays.array(heading, failures));
                Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
                return Optional.of(assertionError);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static List<Throwable> extractFailuresOf(Object multipleFailuresError) {
        return (List)PropertyOrFieldSupport.EXTRACTION.getValueOf("failures", multipleFailuresError);
    }
}

