/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldHaveMethods
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveMethods(Class<?> actual, boolean declared, SortedSet<String> expected, SortedSet<String> missing) {
        return new ShouldHaveMethods(actual, expected, missing, declared);
    }

    public static ErrorMessageFactory shouldHaveMethods(Class<?> actual, boolean declared, SortedSet<String> expected, String modifier, Map<String, String> nonMatching) {
        return new ShouldHaveMethods(actual, expected, modifier, nonMatching, declared);
    }

    public static ErrorMessageFactory shouldNotHaveMethods(Class<?> actual, String modifier, boolean declared, SortedSet<String> actualMethodsHavingModifier) {
        return new ShouldHaveMethods(actual, modifier, declared, actualMethodsHavingModifier);
    }

    public static ErrorMessageFactory shouldNotHaveMethods(Class<?> actual, boolean declared, SortedSet<String> actualMethodsHavingModifier) {
        return new ShouldHaveMethods(actual, null, declared, actualMethodsHavingModifier);
    }

    private ShouldHaveMethods(Class<?> actual, Set<String> expected, Set<String> missing, boolean declared) {
        super("%nExpecting%n  %s%nto have " + (declared ? "declared " : "") + "methods:%n  %s%nbut could not find:%n  %s", actual, expected, missing);
    }

    private ShouldHaveMethods(Class<?> actual, Set<String> expected, String modifier, Map<String, String> nonMatching, boolean declared) {
        super("%nExpecting%n  %s%nto have " + (declared ? "declared " : "") + modifier + " methods:%n  %s%nbut the following are not " + modifier + ":%n  %s", actual, expected, nonMatching);
    }

    private ShouldHaveMethods(Class<?> actual, String modifier, boolean declared, Set<String> actualMethodsHavingModifier) {
        super("%nExpecting%n  %s%nnot to have any " + (declared ? "declared " : "") + (String)(modifier != null && !modifier.isEmpty() ? modifier + " " : "") + "methods but it has the following:%n  %s", actual, actualMethodsHavingModifier);
    }
}

