/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Sets;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class DeepDifference {
    private static final String MISSING_FIELDS = "%s can't be compared to %s as %s does not declare all %s fields, it lacks these:%s";
    private static final Map<Class<?>, Boolean> customEquals = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> customHash = new ConcurrentHashMap();

    public static List<Difference> determineDifferences(Object a, Object b, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        comparatorByPropertyOrField = comparatorByPropertyOrField == null ? new TreeMap() : comparatorByPropertyOrField;
        comparatorByType = comparatorByType == null ? TypeComparators.defaultTypeComparators() : comparatorByType;
        return DeepDifference.determineDifferences(a, b, null, comparatorByPropertyOrField, comparatorByType);
    }

    private static List<Difference> determineDifferences(Object a, Object b, List<String> parentPath, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        HashSet<DualKey> visited = new HashSet<DualKey>();
        Deque<DualKey> toCompare = DeepDifference.initStack(a, b, parentPath, comparatorByPropertyOrField, comparatorByType);
        ArrayList<Difference> differences = new ArrayList<Difference>();
        while (!toCompare.isEmpty()) {
            Map map;
            DualKey dualKey = toCompare.removeFirst();
            visited.add(dualKey);
            List<String> currentPath = dualKey.getPath();
            Object key1 = dualKey.key1;
            Object key2 = dualKey.key2;
            if (key1 == key2 || DeepDifference.hasCustomComparator(dualKey, comparatorByPropertyOrField, comparatorByType) && Objects.propertyOrFieldValuesAreEqual(key1, key2, dualKey.getConcatenatedPath(), comparatorByPropertyOrField, comparatorByType)) continue;
            if (key1 == null || key2 == null) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Collection) {
                if (!(key2 instanceof Collection)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof Collection) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedSet) {
                if (!(key2 instanceof SortedSet)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof SortedSet) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedMap) {
                if (!(key2 instanceof SortedMap)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof SortedMap) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Map) {
                if (!(key2 instanceof Map)) {
                    differences.add(new Difference(currentPath, key1, key2));
                    continue;
                }
            } else if (key2 instanceof Map) {
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1.getClass().isArray()) {
                if (DeepDifference.compareArrays(key1, key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedSet) {
                SortedSet set = (SortedSet)key1;
                if (DeepDifference.compareOrderedCollection(set, (Collection)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof List) {
                List list = (List)key1;
                if (DeepDifference.compareOrderedCollection(list, (Collection)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Collection) {
                Collection collection = (Collection)key1;
                if (DeepDifference.compareUnorderedCollection(collection, (Collection)key2, currentPath, toCompare, visited, comparatorByPropertyOrField, comparatorByType)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof SortedMap) {
                map = (SortedMap)key1;
                if (DeepDifference.compareSortedMap(map, (SortedMap)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (key1 instanceof Map) {
                map = (Map)key1;
                if (DeepDifference.compareUnorderedMap(map, (Map)key2, currentPath, toCompare, visited)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            if (DeepDifference.hasCustomEquals(key1.getClass())) {
                if (key1.equals(key2)) continue;
                differences.add(new Difference(currentPath, key1, key2));
                continue;
            }
            Set<String> key1FieldsNames = DeepDifference.getFieldsNames(Objects.getDeclaredFieldsIncludingInherited(key1.getClass()));
            Set<String> key2FieldsNames = DeepDifference.getFieldsNames(Objects.getDeclaredFieldsIncludingInherited(key2.getClass()));
            if (!key2FieldsNames.containsAll(key1FieldsNames)) {
                HashSet<String> key1FieldsNamesNotInKey2 = Sets.newHashSet(key1FieldsNames);
                key1FieldsNamesNotInKey2.removeAll(key2FieldsNames);
                String missingFields = ((Object)key1FieldsNamesNotInKey2).toString();
                String key2ClassName = key2.getClass().getName();
                String key1ClassName = key1.getClass().getName();
                String missingFieldsDescription = MISSING_FIELDS.formatted(key1ClassName, key2ClassName, key2.getClass().getSimpleName(), key1.getClass().getSimpleName(), missingFields);
                differences.add(new Difference(currentPath, key1, key2, missingFieldsDescription));
                continue;
            }
            for (String fieldName : key1FieldsNames) {
                ArrayList<String> path = new ArrayList<String>(currentPath);
                path.add(fieldName);
                DualKey dk = new DualKey(path, PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, key1), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, key2));
                if (visited.contains(dk)) continue;
                toCompare.addFirst(dk);
            }
        }
        return differences;
    }

    private static boolean hasCustomComparator(DualKey dualKey, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        String fieldName = dualKey.getConcatenatedPath();
        if (comparatorByPropertyOrField.containsKey(fieldName)) {
            return true;
        }
        Class<?> keyType = dualKey.key1 != null ? dualKey.key1.getClass() : dualKey.key2.getClass();
        return comparatorByType.getComparatorForType(keyType) != null;
    }

    private static Deque<DualKey> initStack(Object a, Object b, List<String> parentPath, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        LinkedList<DualKey> stack = new LinkedList<DualKey>();
        boolean isRootObject = parentPath == null;
        ArrayList<String> currentPath = isRootObject ? new ArrayList<String>() : parentPath;
        DualKey basicDualKey = new DualKey(currentPath, a, b);
        if (!(a == null || b == null || DeepDifference.isContainerType(a) || DeepDifference.isContainerType(b) || !isRootObject && DeepDifference.hasCustomComparator(basicDualKey, comparatorByPropertyOrField, comparatorByType))) {
            Set<String> aFieldsNames = DeepDifference.getFieldsNames(Objects.getDeclaredFieldsIncludingInherited(a.getClass()));
            if (!aFieldsNames.isEmpty()) {
                Set<String> bFieldsNames = DeepDifference.getFieldsNames(Objects.getDeclaredFieldsIncludingInherited(b.getClass()));
                if (!bFieldsNames.containsAll(aFieldsNames)) {
                    stack.addFirst(basicDualKey);
                } else {
                    for (String fieldName : aFieldsNames) {
                        ArrayList<String> fieldPath = new ArrayList<String>(currentPath);
                        fieldPath.add(fieldName);
                        DualKey dk = new DualKey(fieldPath, PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, a), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, b));
                        stack.addFirst(dk);
                    }
                }
            } else {
                stack.addFirst(basicDualKey);
            }
        } else {
            stack.addFirst(basicDualKey);
        }
        return stack;
    }

    private static Set<String> getFieldsNames(Collection<Field> fields) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    private static boolean isContainerType(Object o) {
        return o instanceof Collection || o instanceof Map;
    }

    private static boolean compareArrays(Object array1, Object array2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        int len = Array.getLength(array1);
        if (len != Array.getLength(array2)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            DualKey dk = new DualKey(path, Array.get(array1, i), Array.get(array2, i));
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K, V> boolean compareOrderedCollection(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        Iterator<V> i2 = col2.iterator();
        for (K k : col1) {
            DualKey dk = new DualKey(path, k, i2.next());
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K, V> boolean compareUnorderedCollectionByHashCodes(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        HashMap<Integer, V> fastLookup = new HashMap<Integer, V>();
        for (Object o : col2) {
            fastLookup.put(DeepDifference.deepHashCode(o), o);
        }
        for (Object o : col1) {
            Object other = fastLookup.get(DeepDifference.deepHashCode(o));
            if (other == null) {
                return false;
            }
            DualKey dk = new DualKey(path, o, other);
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K, V> boolean compareUnorderedCollection(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        boolean noCustomComparators;
        if (col1.size() != col2.size()) {
            return false;
        }
        boolean bl = noCustomComparators = comparatorByPropertyOrField.isEmpty() && comparatorByType.isEmpty();
        if (noCustomComparators && col1 instanceof Set) {
            return DeepDifference.compareUnorderedCollectionByHashCodes(col1, col2, path, toCompare, visited);
        }
        LinkedList<V> col2Copy = new LinkedList<V>(col2);
        block0: for (K o1 : col1) {
            Iterator iterator = col2Copy.iterator();
            while (iterator.hasNext()) {
                Object o2 = iterator.next();
                if (!DeepDifference.determineDifferences(o1, o2, path, comparatorByPropertyOrField, comparatorByType).isEmpty()) continue;
                iterator.remove();
                continue block0;
            }
        }
        return col2Copy.isEmpty();
    }

    private static <K1, V1, K2, V2> boolean compareSortedMap(SortedMap<K1, V1> map1, SortedMap<K2, V2> map2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry<K2, V2>> i2 = map2.entrySet().iterator();
        for (Map.Entry<K1, V1> entry1 : map1.entrySet()) {
            Map.Entry<K2, V2> entry2 = i2.next();
            DualKey dk = new DualKey(path, entry1.getKey(), entry2.getKey());
            if (!visited.contains(dk)) {
                toCompare.addFirst(dk);
            }
            if (visited.contains(dk = new DualKey(path, entry1.getValue(), entry2.getValue()))) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K1, V1, K2, V2> boolean compareUnorderedMap(Map<K1, V1> map1, Map<K2, V2> map2, List<String> path, Deque<DualKey> toCompare, Set<DualKey> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        HashMap<Integer, Map.Entry<K2, V2>> fastLookup = new HashMap<Integer, Map.Entry<K2, V2>>();
        for (Map.Entry<K2, V2> entry : map2.entrySet()) {
            fastLookup.put(DeepDifference.deepHashCode(entry.getKey()), entry);
        }
        for (Map.Entry<Object, Object> entry : map1.entrySet()) {
            Map.Entry other = (Map.Entry)fastLookup.get(DeepDifference.deepHashCode(entry.getKey()));
            if (other == null) {
                return false;
            }
            DualKey dk = new DualKey(path, entry.getKey(), other.getKey());
            if (!visited.contains(dk)) {
                toCompare.addFirst(dk);
            }
            if (visited.contains(dk = new DualKey(path, entry.getValue(), other.getValue()))) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    static boolean hasCustomEquals(Class<?> c) {
        if (customEquals.containsKey(c)) {
            return customEquals.get(c);
        }
        Class<?> origClass = c;
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customEquals.put(origClass, false);
        return false;
    }

    static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                stack.addAll(0, collection);
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                stack.addAll(0, map.keySet());
                stack.addAll(0, map.values());
                continue;
            }
            if (obj instanceof Double || obj instanceof Float) {
                stack.add(Math.round(((Number)obj).doubleValue()));
                continue;
            }
            if (DeepDifference.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Set<Field> fields = Objects.getDeclaredFieldsIncludingInherited(obj.getClass());
            for (Field field : fields) {
                stack.addFirst(PropertyOrFieldSupport.COMPARISON.getSimpleValue(field.getName(), obj));
            }
        }
        return hash;
    }

    static boolean hasCustomHashCode(Class<?> c) {
        Class<?> origClass = c;
        if (customHash.containsKey(c)) {
            return customHash.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customHash.put(origClass, false);
        return false;
    }

    private static final class DualKey {
        private final List<String> path;
        private final Object key1;
        private final Object key2;

        private DualKey(List<String> path, Object key1, Object key2) {
            this.path = path;
            this.key1 = key1;
            this.key2 = key2;
        }

        public boolean equals(Object other) {
            if (!(other instanceof DualKey)) {
                return false;
            }
            DualKey that = (DualKey)other;
            return this.key1 == that.key1 && this.key2 == that.key2;
        }

        public int hashCode() {
            int h1 = this.key1 != null ? this.key1.hashCode() : 0;
            int h2 = this.key2 != null ? this.key2.hashCode() : 0;
            return h1 + h2;
        }

        public String toString() {
            return "DualKey [key1=" + String.valueOf(this.key1) + ", key2=" + String.valueOf(this.key2) + "]";
        }

        public List<String> getPath() {
            return this.path;
        }

        public String getConcatenatedPath() {
            return Strings.join(this.path).with(".");
        }
    }

    public static class Difference {
        List<String> path;
        Object actual;
        Object other;
        Optional<String> description;

        public Difference(List<String> path, Object actual, Object other) {
            this(path, actual, other, null);
        }

        public Difference(List<String> path, Object actual, Object other, String description) {
            this.path = path;
            this.actual = actual;
            this.other = other;
            this.description = Optional.ofNullable(description);
        }

        public List<String> getPath() {
            return this.path;
        }

        public Object getActual() {
            return this.actual;
        }

        public Object getOther() {
            return this.other;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description.isPresent() ? "Difference [path=%s, actual=%s, other=%s, description=%s]".formatted(this.path, this.actual, this.other, this.description.get()) : "Difference [path=%s, actual=%s, other=%s]".formatted(this.path, this.actual, this.other);
        }
    }
}

