/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.error.MultisetShouldContainAtLeastTimes;
import org.assertj.guava.error.MultisetShouldContainAtMostTimes;
import org.assertj.guava.error.MultisetShouldContainTimes;

public class MultisetAssert<T>
extends AbstractIterableAssert<MultisetAssert<T>, Multiset<? extends T>, T, ObjectAssert<T>> {
    @VisibleForTesting
    Failures failures = Failures.instance();

    protected MultisetAssert(Multiset<? extends T> actual) {
        super(actual, MultisetAssert.class);
    }

    public MultisetAssert<T> contains(int expectedCount, T expected) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Preconditions.checkArgument((expectedCount >= 0 ? 1 : 0) != 0, (Object)"The expected count should not be negative.");
        int actualCount = ((Multiset)this.actual).count(expected);
        if (actualCount != expectedCount) {
            throw this.failures.failure((AssertionInfo)this.info, MultisetShouldContainTimes.shouldContainTimes((Multiset)this.actual, expected, expectedCount, actualCount));
        }
        return (MultisetAssert)this.myself;
    }

    public MultisetAssert<T> containsAtLeast(int minimumCount, T expected) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Preconditions.checkArgument((minimumCount >= 0 ? 1 : 0) != 0, (Object)"The minimum count should not be negative.");
        int actualCount = ((Multiset)this.actual).count(expected);
        if (actualCount < minimumCount) {
            throw this.failures.failure((AssertionInfo)this.info, MultisetShouldContainAtLeastTimes.shouldContainAtLeastTimes((Multiset)this.actual, expected, minimumCount, actualCount));
        }
        return (MultisetAssert)this.myself;
    }

    public MultisetAssert<T> containsAtMost(int maximumCount, T expected) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Preconditions.checkArgument((maximumCount >= 0 ? 1 : 0) != 0, (Object)"The maximum count should not be negative.");
        int actualCount = ((Multiset)this.actual).count(expected);
        if (actualCount > maximumCount) {
            throw this.failures.failure((AssertionInfo)this.info, MultisetShouldContainAtMostTimes.shouldContainAtMostTimes((Multiset)this.actual, expected, maximumCount, actualCount));
        }
        return (MultisetAssert)this.myself;
    }

    protected ObjectAssert<T> toAssert(T value, String description) {
        return null;
    }
}

