/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.jodatime.api;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.jodatime.error.ShouldBeAfter;
import org.assertj.jodatime.error.ShouldBeAfterOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeBefore;
import org.assertj.jodatime.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringHours;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringMillis;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.jodatime.error.ShouldHaveDayOfMonthEqualTo;
import org.assertj.jodatime.error.ShouldHaveHourOfDayEqualTo;
import org.assertj.jodatime.error.ShouldHaveMillisOfSecondEqualTo;
import org.assertj.jodatime.error.ShouldHaveMinuteOfHourEqualTo;
import org.assertj.jodatime.error.ShouldHaveMonthOfYearEqualTo;
import org.assertj.jodatime.error.ShouldHaveSecondOfMinuteEqualTo;
import org.assertj.jodatime.error.ShouldHaveYearEqualTo;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DateTimeAssert
extends AbstractAssert<DateTimeAssert, DateTime> {
    public static final String NULL_DATE_TIME_PARAMETER_MESSAGE = "The DateTime to compare actual with should not be null";

    protected DateTimeAssert(Class<DateTimeAssert> selfType, DateTime actual) {
        super((Object)actual, selfType);
    }

    protected DateTime getActual() {
        return (DateTime)this.actual;
    }

    public DateTimeAssert hasYear(int expectedYear) {
        this.isNotNull();
        if (((DateTime)this.actual).getYear() != expectedYear) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveYearEqualTo.shouldHaveYearEqualTo(this.actual, ((DateTime)this.actual).getYear(), expectedYear));
        }
        return this;
    }

    public DateTimeAssert hasMonthOfYear(int expectedMonthOfYear) {
        this.isNotNull();
        if (((DateTime)this.actual).getMonthOfYear() != expectedMonthOfYear) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveMonthOfYearEqualTo.shouldHaveMonthOfYearEqualTo(this.actual, ((DateTime)this.actual).getMonthOfYear(), expectedMonthOfYear));
        }
        return this;
    }

    public DateTimeAssert hasDayOfMonth(int expectedDayOfMonth) {
        this.isNotNull();
        if (((DateTime)this.actual).getDayOfMonth() != expectedDayOfMonth) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDayOfMonthEqualTo.shouldHaveDayOfMonthEqualTo(this.actual, ((DateTime)this.actual).getDayOfMonth(), expectedDayOfMonth));
        }
        return this;
    }

    public DateTimeAssert hasHourOfDay(int expectedHourOfDay) {
        this.isNotNull();
        if (((DateTime)this.actual).getHourOfDay() != expectedHourOfDay) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveHourOfDayEqualTo.shouldHaveHoursEqualTo(this.actual, ((DateTime)this.actual).getHourOfDay(), expectedHourOfDay));
        }
        return this;
    }

    public DateTimeAssert hasMinuteOfHour(int expectedMinuteOfHour) {
        this.isNotNull();
        if (((DateTime)this.actual).getMinuteOfHour() != expectedMinuteOfHour) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveMinuteOfHourEqualTo.shouldHaveMinuteOfHourEqualTo(this.actual, ((DateTime)this.actual).getMinuteOfHour(), expectedMinuteOfHour));
        }
        return this;
    }

    public DateTimeAssert hasSecondOfMinute(int expectedSecondOfMinute) {
        this.isNotNull();
        if (((DateTime)this.actual).getSecondOfMinute() != expectedSecondOfMinute) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveSecondOfMinuteEqualTo.shouldHaveSecondOfMinuteEqualTo(this.actual, ((DateTime)this.actual).getSecondOfMinute(), expectedSecondOfMinute));
        }
        return this;
    }

    public DateTimeAssert hasMillisOfSecond(int expectedMillisOfSecond) {
        this.isNotNull();
        if (((DateTime)this.actual).getMillisOfSecond() != expectedMillisOfSecond) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveMillisOfSecondEqualTo.shouldHaveMillisOfSecondEqualTo(this.actual, ((DateTime)this.actual).getMillisOfSecond(), expectedMillisOfSecond));
        }
        return this;
    }

    public DateTimeAssert isBefore(DateTime other) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((DateTime)this.actual).isBefore((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isBefore(String dateTimeAsString) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBefore(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isBeforeOrEqualTo(DateTime other) {
        if (this.actual == other) {
            return this;
        }
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((DateTime)this.actual).isAfter((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isBeforeOrEqualTo(String dateTimeAsString) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBeforeOrEqualTo(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isAfterOrEqualTo(DateTime other) {
        if (this.actual == other) {
            return this;
        }
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((DateTime)this.actual).isBefore((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isAfterOrEqualTo(String dateTimeAsString) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfterOrEqualTo(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isAfter(DateTime other) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((DateTime)this.actual).isAfter((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isAfter(String dateTimeAsString) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfter(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isEqualToIgnoringMillis(DateTime other) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.areEqualIgnoringMillis((DateTime)this.actual, other.toDateTime(((DateTime)this.actual).getZone()))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMillis.shouldBeEqualIgnoringMillis(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualToIgnoringSeconds(DateTime other) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.areEqualIgnoringSeconds((DateTime)this.actual, other.toDateTime(((DateTime)this.actual).getZone()))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualToIgnoringMinutes(DateTime other) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.areEqualIgnoringMinutes((DateTime)this.actual, other.toDateTime(((DateTime)this.actual).getZone()))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualToIgnoringHours(DateTime other) {
        this.isNotNull();
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.haveSameYearMonthAndDayOfMonth((DateTime)this.actual, other.toDateTime(((DateTime)this.actual).getZone()))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualTo(DateTime expected) {
        if (this.actual == expected) {
            return this;
        }
        this.isNotNull();
        return (DateTimeAssert)super.isEqualTo((Object)new DateTime((Object)expected, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isEqualTo(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isEqualTo(new DateTime((Object)dateTimeAsString));
    }

    public DateTimeAssert isNotEqualTo(DateTime expected) {
        DateTime other = this.actual == null ? expected : new DateTime((Object)expected, ((DateTime)this.actual).getZone());
        return (DateTimeAssert)super.isNotEqualTo((Object)other);
    }

    public DateTimeAssert isNotEqualTo(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isNotEqualTo(new DateTime((Object)dateTimeAsString));
    }

    public DateTimeAssert isIn(DateTime ... expected) {
        this.checkIsNotNullAndNotEmpty(expected);
        return (DateTimeAssert)super.isIn((Object[])this.changeToActualTimeZone(expected));
    }

    public DateTimeAssert isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public DateTimeAssert isNotIn(DateTime ... expected) {
        this.checkIsNotNullAndNotEmpty(expected);
        return (DateTimeAssert)super.isNotIn((Object[])this.changeToActualTimeZone(expected));
    }

    public DateTimeAssert isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isNotIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    private DateTime[] convertToDateTimeArray(String ... dateTimesAsString) {
        DateTime[] dates = new DateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = this.actual == null ? new DateTime((Object)dateTimesAsString[i]) : new DateTime((Object)dateTimesAsString[i], ((DateTime)this.actual).getZone());
        }
        return dates;
    }

    private DateTime[] changeToActualTimeZone(DateTime ... dateTimes) {
        DateTime[] dates = new DateTime[dateTimes.length];
        for (int i = 0; i < dateTimes.length; ++i) {
            dates[i] = this.actual == null ? dateTimes[i] : new DateTime((Object)dateTimes[i], ((DateTime)this.actual).getZone());
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given DateTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given DateTime array should not be empty");
        }
    }

    private static void assertDateTimeParameterIsNotNull(DateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException(NULL_DATE_TIME_PARAMETER_MESSAGE);
        }
    }

    private static void assertDateTimeAsStringParameterIsNotNull(String dateTimeAsString) {
        if (dateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the DateTime to compare actual with should not be null");
        }
    }

    private static boolean areEqualIgnoringMillis(DateTime actual, DateTime other) {
        return DateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecondOfMinute() == other.getSecondOfMinute();
    }

    private static boolean areEqualIgnoringSeconds(DateTime actual, DateTime other) {
        return DateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinuteOfHour() == other.getMinuteOfHour();
    }

    private static boolean areEqualIgnoringMinutes(DateTime actual, DateTime other) {
        return DateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHourOfDay() == other.getHourOfDay();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(DateTime actual, DateTime other) {
        return DateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(DateTime actual, DateTime other) {
        return DateTimeAssert.haveSameYear(actual, other) && actual.getMonthOfYear() == other.getMonthOfYear();
    }

    private static boolean haveSameYear(DateTime actual, DateTime other) {
        return actual.getYear() == other.getYear();
    }
}

