/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.atmosphere.jboss.websockets.oio.ClosingStrategy;
import org.atmosphere.jboss.websockets.oio.HttpRequestBridge;
import org.atmosphere.jboss.websockets.oio.HttpResponseBridge;
import org.atmosphere.jboss.websockets.oio.OioWebSocket;
import org.atmosphere.jboss.websockets.oio.internal.Handshake;
import org.atmosphere.jboss.websockets.oio.internal.WebSocketHeaders;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf00.Hybi00Handshake;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf07.Hybi07Handshake;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf08.Hybi08Handshake;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf13.Hybi13Handshake;

public class WebSocketConnectionManager {
    private static final List<Handshake> websocketHandshakes;

    public static OioWebSocket establish(String protocolName, HttpRequestBridge request, HttpResponseBridge response, ClosingStrategy closingStrategy) throws IOException {
        for (Handshake handshake : websocketHandshakes) {
            if (!handshake.matches(request)) continue;
            response.startUpgrade();
            response.setHeader("Upgrade", "WebSocket");
            response.setHeader("Connection", "Upgrade");
            if (protocolName != null) {
                WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.set(response, protocolName);
            } else {
                WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.set(response, null);
            }
            byte[] handShakeData = handshake.generateResponse(request, response);
            response.getOutputStream().write(handShakeData);
            OioWebSocket webSocket = handshake.getWebSocket(request, response, closingStrategy);
            response.sendUpgrade();
            return webSocket;
        }
        return null;
    }

    static {
        ArrayList<Handshake> handshakeList = new ArrayList<Handshake>();
        handshakeList.add(new Hybi13Handshake());
        handshakeList.add(new Hybi07Handshake());
        handshakeList.add(new Hybi08Handshake());
        handshakeList.add(new Hybi00Handshake());
        websocketHandshakes = Collections.unmodifiableList(handshakeList);
    }
}

