/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio.internal.protocol.ietf13;

import java.io.IOException;
import org.atmosphere.jboss.websockets.oio.ClosingStrategy;
import org.atmosphere.jboss.websockets.oio.HttpRequestBridge;
import org.atmosphere.jboss.websockets.oio.HttpResponseBridge;
import org.atmosphere.jboss.websockets.oio.OioWebSocket;
import org.atmosphere.jboss.websockets.oio.internal.WebSocketHeaders;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf07.Hybi07Handshake;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf13.Hybi13Socket;

public class Hybi13Handshake
extends Hybi07Handshake {
    public Hybi13Handshake() {
        super("13");
    }

    public OioWebSocket getWebSocket(HttpRequestBridge request, HttpResponseBridge response, ClosingStrategy closingStrategy) throws IOException {
        return Hybi13Socket.from(request, response, closingStrategy);
    }

    public byte[] generateResponse(HttpRequestBridge request, HttpResponseBridge response) throws IOException {
        WebSocketHeaders.ORIGIN.copy(request, response);
        WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.copy(request, response);
        WebSocketHeaders.SEC_WEBSOCKET_LOCATION.set(response, this.getWebSocketLocation(request));
        String key = WebSocketHeaders.SEC_WEBSOCKET_KEY.get(request);
        String solution = this.solve(key);
        WebSocketHeaders.SEC_WEBSOCKET_ACCEPT.set(response, solution);
        return new byte[0];
    }
}

