/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import org.audit4j.core.ConcurrentConfigurationContext;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.exception.HandlerException;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.util.Log;

public class AuditEventProcessor {
    private ConcurrentConfigurationContext configContext;

    public void process(AuditEvent event) {
        this.executeHandlers(event);
    }

    public void processBatch(EventBatch batch) {
        this.executeHandlers(batch);
    }

    void executeHandlers(AuditEvent event) {
        String formattedEvent = this.configContext.getLayout().format(event);
        for (Handler handler : this.configContext.getHandlers()) {
            handler.setAuditEvent(event);
            handler.setQuery(formattedEvent);
            try {
                handler.handle();
                handler.handle(event);
                handler.handle(formattedEvent);
            }
            catch (HandlerException e) {
                Log.warn((Object)"Failed to submit audit event.", e);
            }
        }
    }

    void executeHandlers(EventBatch<AuditEvent> batch) {
        String formattedEvent = "";
        for (AuditEvent auditEvent : batch) {
            formattedEvent = formattedEvent + this.configContext.getLayout().format(auditEvent) + '\n';
        }
        for (Handler handler : this.configContext.getHandlers()) {
            handler.setEventBatch(batch);
            handler.setQuery(formattedEvent);
            try {
                handler.handle(batch);
                handler.handle(formattedEvent);
            }
            catch (HandlerException e) {
                Log.warn((Object)"Failed to submit audit event.", e);
            }
        }
    }

    public void setConfigContext(ConcurrentConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

