/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.lang.reflect.Method;
import java.util.List;
import org.audit4j.core.Configuration;
import org.audit4j.core.Context;
import org.audit4j.core.IAuditManager;
import org.audit4j.core.RunStatus;
import org.audit4j.core.dto.AnnotationAuditEvent;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.filter.AuditAnnotationFilter;

public final class AuditManager
implements IAuditManager {
    private static volatile IAuditManager auditManager;

    private AuditManager() {
    }

    @Override
    public boolean audit(AuditEvent event) {
        Context.getAuditStream().write(event);
        return true;
    }

    public boolean audit(EventBatch batch) {
        Context.getAuditStream().writeBatch(batch);
        return true;
    }

    @Override
    public boolean audit(Class<?> clazz, Method method, Object[] args) {
        return this.audit(new AnnotationAuditEvent(clazz, method, args));
    }

    @Override
    public boolean audit(AnnotationAuditEvent annotationEvent) {
        List<AuditAnnotationFilter> filters = Context.getConfigContext().getAnnotationFilters();
        if (!filters.isEmpty()) {
            for (AuditAnnotationFilter filter : filters) {
                if (filter.accepts(annotationEvent)) continue;
                return false;
            }
        }
        Context.getAuditStream().write(annotationEvent);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IAuditManager getInstance() {
        IAuditManager result = auditManager;
        if (result != null) return result;
        Class<AuditManager> clazz = AuditManager.class;
        synchronized (AuditManager.class) {
            result = auditManager;
            if (result != null) return result;
            Context.init();
            auditManager = result = new AuditManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    @Deprecated
    public static IAuditManager getConfigurationInstance(Configuration configuration) {
        Context.setConfig(configuration);
        return AuditManager.getInstance();
    }

    @Deprecated
    public static IAuditManager initWithConfiguration(Configuration configuration) {
        Context.setConfig(configuration);
        return AuditManager.getInstance();
    }

    public static IAuditManager startWithConfiguration(Configuration configuration) {
        Context.setConfig(configuration);
        return AuditManager.getInstance();
    }

    public static IAuditManager startWithConfiguration(String configFilePath) {
        Context.setConfigFilePath(configFilePath);
        return AuditManager.getInstance();
    }

    public static IAuditManager start() {
        return AuditManager.getInstance();
    }

    public static void shutdown() {
        auditManager = null;
        Context.stop();
    }

    public static void enable() {
        Context.enable();
    }

    public static void disable() {
        Context.disable();
    }

    public static boolean isInitialized() {
        return Context.getStatus().equals((Object)RunStatus.RUNNING);
    }
}

