/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.audit4j.core.Context;
import org.audit4j.core.MetaData;
import org.audit4j.core.RunStatus;
import org.audit4j.core.filter.AuditAnnotationFilter;
import org.audit4j.core.filter.AuditEventFilter;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.layout.Layout;

public final class ConcurrentConfigurationContext {
    private final List<Handler> handlers = new CopyOnWriteArrayList<Handler>();
    private final Map<String, String> properties = new ConcurrentHashMap();
    private final List<AuditEventFilter> filters = new CopyOnWriteArrayList<AuditEventFilter>();
    private final List<AuditAnnotationFilter> annotationFilters = new CopyOnWriteArrayList<AuditAnnotationFilter>();
    private Layout layout;
    private MetaData metaData;
    @Deprecated
    private RunStatus runStatus = RunStatus.READY;

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<AuditEventFilter> getFilters() {
        return this.filters;
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void addFilter(AuditEventFilter filter) {
        this.filters.add(filter);
    }

    public List<AuditAnnotationFilter> getAnnotationFilters() {
        return this.annotationFilters;
    }

    public void addAnnotationFilter(AuditAnnotationFilter annotationFilter) {
        this.annotationFilters.add(annotationFilter);
    }

    public boolean hasMetadata() {
        return Context.getConfigContext().getMetaData() != null;
    }

    @Deprecated
    public RunStatus getRunStatus() {
        return this.runStatus;
    }

    @Deprecated
    public void setRunStatus(RunStatus runStatus) {
        this.runStatus = runStatus;
    }
}

