/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.audit4j.core.AnnotationTransformer;
import org.audit4j.core.DummyMetaData;
import org.audit4j.core.MetaData;
import org.audit4j.core.filter.AuditEventFilter;
import org.audit4j.core.handler.ConsoleAuditHandler;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.jmx.JMXConfig;
import org.audit4j.core.layout.Layout;
import org.audit4j.core.layout.SimpleLayout;

public class Configuration
implements Serializable {
    private static final long serialVersionUID = -3370288956459623002L;
    private Layout layout;
    private List<Handler> handlers;
    private MetaData metaData;
    private Map<String, String> properties;
    private List<AuditEventFilter> filters;
    private String commands;
    private JMXConfig jmx;
    private AnnotationTransformer annotationTransformer;
    public static Configuration INSTANCE = new Configuration();
    public static Configuration DEFAULT = Configuration.getDefault();

    private static Configuration getDefault() {
        Configuration config = new Configuration();
        config.addHandler(new ConsoleAuditHandler());
        config.setMetaData(new DummyMetaData());
        config.setLayout(new SimpleLayout());
        config.addProperty("log.file.location", "user.dir");
        return config;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public List<Handler> getHandlers() {
        if (null == this.handlers) {
            this.handlers = new ArrayList<Handler>();
        }
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public void addHandler(Handler handler) {
        if (null == this.handlers) {
            this.handlers = new ArrayList<Handler>();
        }
        this.handlers.add(handler);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Map<String, String> getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public List<AuditEventFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<AuditEventFilter>();
        }
        return this.filters;
    }

    public void setFilters(List<AuditEventFilter> filters) {
        this.filters = filters;
    }

    public void addFilter(AuditEventFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<AuditEventFilter>();
        }
        this.filters.add(filter);
    }

    public String getCommands() {
        return this.commands;
    }

    public void setCommands(String options) {
        this.commands = options;
    }

    public JMXConfig getJmx() {
        return this.jmx;
    }

    public void setJmx(JMXConfig jmx) {
        this.jmx = jmx;
    }

    public AnnotationTransformer getAnnotationTransformer() {
        return this.annotationTransformer;
    }

    public void setAnnotationTransformer(AnnotationTransformer annotationTransformer) {
        this.annotationTransformer = annotationTransformer;
    }
}

