/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.audit4j.core.ConfigProvider;
import org.audit4j.core.Configuration;
import org.audit4j.core.XMLConfigProvider;
import org.audit4j.core.YAMLConfigProvider;
import org.audit4j.core.exception.ConfigurationException;
import org.audit4j.core.util.AuditUtil;
import org.audit4j.core.util.ClassLoaderUtils;
import org.audit4j.core.util.Log;

public class Configurations {
    public static final String XML_EXTENTION = "xml";
    public static final String YML_EXTENTION = "yml";
    public static final String YAML_EXTENTION = "yaml";
    public static final String CONFIG_FILE_NAME = "audit4j.conf";
    public static final String DEFAULT_CONFIG_FILE_NAME = "audit4j.conf.yml";
    static final String CONFIG_PROPERTY_EXCEPTION_ID = "CONF_004";
    static final String CONFIG_EXTENTION_NOT_SUPPORTED_EXCEPTION_ID = "CONF_005";
    static final String FILE_NOT_FOUND_EXCEPTION_ID = "CONF_006";
    static final String SYSTEM_PROPERTY_CONFIG_VARIABLE_NAME = "audit4j.conf.file.path";
    static final String ENVIRONMENT_CONFIG_VARIABLE_NAME = "AUDIT4J_CONF_FILE_PATH";

    private Configurations() {
    }

    static Configuration loadConfig(String configFilePath) throws ConfigurationException {
        return Configurations.loadConfig(Configurations.resolveConfigFileAsStream(configFilePath));
    }

    static Configuration loadConfig(ConfigurationStream stream) throws ConfigurationException {
        ConfigProvider<Configuration> provider = Configurations.getProviderByFileExtention(stream.getExtention());
        return provider.readConfig(stream.getInputStream());
    }

    static ConfigurationStream resolveConfigFileAsStream(String configFilePath) throws ConfigurationException {
        String fileExtention;
        InputStream fileStream;
        if (configFilePath != null) {
            if (new File(configFilePath).isDirectory()) {
                String path = Configurations.scanConfigFile(configFilePath);
                fileStream = Configurations.getFileAsStream(new File(path));
                fileExtention = FilenameUtils.getExtension((String)path);
            } else {
                fileStream = Configurations.getFileAsStream(configFilePath);
                fileExtention = FilenameUtils.getExtension((String)configFilePath);
            }
        } else if (Configurations.hasEnvironmentVariable(ENVIRONMENT_CONFIG_VARIABLE_NAME)) {
            fileStream = Configurations.getFileAsStream(Configurations.getEnvironemtVariableConfigFilePath());
            fileExtention = FilenameUtils.getExtension((String)Configurations.getEnvironemtVariableConfigFilePath().toFile().getName());
        } else if (Configurations.hasSystemPropertyVariable(SYSTEM_PROPERTY_CONFIG_VARIABLE_NAME)) {
            fileStream = Configurations.getFileAsStream(Configurations.getSystemPropertyConfigFilePath());
            fileExtention = FilenameUtils.getExtension((String)Configurations.getSystemPropertyConfigFilePath().toFile().getName());
        } else if (Configurations.getClasspathResourceAsStream(DEFAULT_CONFIG_FILE_NAME) != null) {
            fileStream = Configurations.getClasspathResourceAsStream(DEFAULT_CONFIG_FILE_NAME);
            fileExtention = YML_EXTENTION;
        } else if (Configurations.getClasspathResourceAsStream("audit4j.conf.yaml") != null) {
            fileStream = Configurations.getClasspathResourceAsStream("audit4j.conf.yaml");
            fileExtention = YAML_EXTENTION;
        } else if (Configurations.getClasspathResourceAsStream("audit4j.conf.xml") != null) {
            fileStream = Configurations.getClasspathResourceAsStream("audit4j.conf.xml");
            fileExtention = XML_EXTENTION;
        } else {
            String defaultConfigDir = System.getProperty("user.dir");
            String defaultConfigPath = Configurations.scanConfigFile(defaultConfigDir);
            fileExtention = FilenameUtils.getExtension((String)defaultConfigPath);
            fileStream = Configurations.getFileAsStream(new File(defaultConfigPath));
        }
        ConfigurationStream config = new ConfigurationStream();
        config.setExtention(fileExtention);
        config.setInputStream(fileStream);
        return config;
    }

    static String scanConfigFile(String dirPath) throws ConfigurationException {
        String fullFilePath;
        String filePath = dirPath + File.separator + CONFIG_FILE_NAME + ".";
        if (AuditUtil.isFileExists(filePath + YML_EXTENTION)) {
            fullFilePath = filePath + YML_EXTENTION;
        } else if (AuditUtil.isFileExists(filePath + YAML_EXTENTION)) {
            fullFilePath = filePath + YAML_EXTENTION;
        } else if (AuditUtil.isFileExists(filePath + XML_EXTENTION)) {
            fullFilePath = filePath + XML_EXTENTION;
        } else {
            fullFilePath = filePath + YML_EXTENTION;
            Configurations.generateConfigFile(fullFilePath);
        }
        return fullFilePath;
    }

    static void generateConfigFile(String configFilePath) throws ConfigurationException {
        String fileExtention = FilenameUtils.getExtension((String)configFilePath);
        ConfigProvider<Configuration> provider = Configurations.getProviderByFileExtention(fileExtention);
        if (!AuditUtil.isFileExists(configFilePath)) {
            provider.generateConfig(Configuration.DEFAULT, configFilePath);
        }
    }

    private static ConfigProvider<Configuration> getProviderByFileExtention(String extention) throws ConfigurationException {
        ConfigProvider<Configuration> provider;
        if (XML_EXTENTION.equals(extention)) {
            provider = new XMLConfigProvider<Configuration>(Configuration.class);
        } else if (YML_EXTENTION.equals(extention) || YAML_EXTENTION.equals(extention)) {
            provider = new YAMLConfigProvider<Configuration>(Configuration.class);
        } else {
            throw new ConfigurationException("Given file type is not supported.", CONFIG_EXTENTION_NOT_SUPPORTED_EXCEPTION_ID);
        }
        return provider;
    }

    static Path getEnvironemtVariableConfigFilePath() {
        String value = System.getenv(ENVIRONMENT_CONFIG_VARIABLE_NAME);
        return Paths.get(value, new String[0]);
    }

    static boolean hasEnvironmentVariable(String variable) {
        String value = System.getenv(variable);
        return value != null;
    }

    static Path getSystemPropertyConfigFilePath() {
        String path = System.getProperty(SYSTEM_PROPERTY_CONFIG_VARIABLE_NAME);
        return Paths.get(path, new String[0]);
    }

    static boolean hasSystemPropertyVariable(String variable) {
        String path = System.getProperty(variable);
        return path != null;
    }

    static InputStream getFileAsStream(String resourceFile) throws ConfigurationException {
        return Configurations.getFileAsStream(new File(resourceFile));
    }

    static InputStream getFileAsStream(Path resourceFile) throws ConfigurationException {
        return Configurations.getFileAsStream(resourceFile.toFile());
    }

    static InputStream getFileAsStream(File resourceFile) throws ConfigurationException {
        try {
            return new FileInputStream(resourceFile);
        }
        catch (FileNotFoundException e) {
            Log.error((Object)("File Resource could not be resolved. Given Resource:" + resourceFile), e);
            throw new ConfigurationException("File Resource could not be resolve", FILE_NOT_FOUND_EXCEPTION_ID, e);
        }
    }

    static InputStream getClasspathResourceAsStream(String resourceName) {
        return ClassLoaderUtils.getClassLoader(Configurations.class).getResourceAsStream(resourceName);
    }

    public static class ConfigurationStream {
        private InputStream inputStream;
        private String extention;

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public String getExtention() {
            return this.extention;
        }

        public void setExtention(String extention) {
            this.extention = extention;
        }
    }
}

