/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.audit4j.core.AnnotationTransformer;
import org.audit4j.core.Audit4jBanner;
import org.audit4j.core.ConcurrentConfigurationContext;
import org.audit4j.core.Configuration;
import org.audit4j.core.Configurations;
import org.audit4j.core.DefaultAnnotationTransformer;
import org.audit4j.core.ErrorGuide;
import org.audit4j.core.LifeCycleContext;
import org.audit4j.core.ObjectToFieldsSerializer;
import org.audit4j.core.PreConfigurationContext;
import org.audit4j.core.RunStatus;
import org.audit4j.core.ValidationManager;
import org.audit4j.core.command.CommandProcessor;
import org.audit4j.core.command.impl.BatchCommand;
import org.audit4j.core.command.impl.MetadataCommand;
import org.audit4j.core.command.impl.ObjectSerializerCommand;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.exception.ConfigurationException;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.exception.ValidationException;
import org.audit4j.core.filter.AuditAnnotationFilter;
import org.audit4j.core.filter.AuditEventFilter;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.io.AsyncAnnotationAuditOutputStream;
import org.audit4j.core.io.AsyncAuditOutputStream;
import org.audit4j.core.io.AuditEventOutputStream;
import org.audit4j.core.io.AuditOutputStream;
import org.audit4j.core.io.AuditProcessOutputStream;
import org.audit4j.core.io.BatchProcessStream;
import org.audit4j.core.io.MetadataLookupStream;
import org.audit4j.core.jmx.MBeanAgent;
import org.audit4j.core.schedule.Schedulers;
import org.audit4j.core.util.EnvUtil;
import org.audit4j.core.util.Log;
import org.audit4j.core.util.StopWatch;

public final class Context {
    private static Configuration conf;
    private static String configFilePath;
    private static AuditOutputStream<AuditEvent> auditStream;
    private static ConcurrentConfigurationContext configContext;
    private static final String INIT_FAILED = "initialization failed.!!";
    private static final LifeCycleContext lifeCycle;
    private static AnnotationTransformer annotationTransformer;

    private Context() {
    }

    static final void init() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Audit4jInit");
        if (configContext == null) {
            configContext = new ConcurrentConfigurationContext();
        }
        if (lifeCycle.getStatus().equals((Object)RunStatus.READY) || lifeCycle.getStatus().equals((Object)RunStatus.STOPPED)) {
            Audit4jBanner banner = new Audit4jBanner();
            banner.printBanner();
            Log.info((Object)"Initializing Audit4j...");
            Context.checkEnvironment();
            Log.info((Object)"Loading Configurations...");
            if (conf == null) {
                Context.loadConfig();
            }
            Log.info((Object)"Validating Configurations...");
            if (conf == null) {
                Context.terminate();
                throw new InitializationException(INIT_FAILED);
            }
            try {
                ValidationManager.validateConfigurations(conf);
            }
            catch (ValidationException e1) {
                Context.terminate();
                throw new InitializationException(INIT_FAILED, e1);
            }
            CommandProcessor.getInstance().process(conf.getCommands());
            Context.loadRegistry();
            if (conf.getProperties() == null) {
                conf.setProperties(new HashMap<String, String>());
            } else {
                for (Map.Entry<String, String> entry : conf.getProperties().entrySet()) {
                    if (!System.getProperties().containsKey(entry.getValue())) continue;
                    conf.getProperties().put(entry.getKey(), System.getProperty(entry.getValue()));
                }
            }
            configContext.getProperties().putAll(conf.getProperties());
            Context.initHandlers();
            Context.initLayout();
            annotationTransformer = conf.getAnnotationTransformer() == null ? Context.getDefaultAnnotationTransformer() : conf.getAnnotationTransformer();
            Context.initStreams();
            if (!conf.getFilters().isEmpty()) {
                Log.info((Object)"Registoring Filters...");
            }
            for (AuditEventFilter filter : conf.getFilters()) {
                configContext.addFilter(filter);
                Log.info((Object)(filter.getClass().getName() + " Registored..."));
            }
            configContext.setMetaData(conf.getMetaData());
            Log.info((Object)"Executing Schedulers...");
            Schedulers.taskRegistry().scheduleAll();
            if (conf.getJmx() != null) {
                MBeanAgent agent = new MBeanAgent();
                agent.setJmxConfig(conf.getJmx());
                agent.init();
                agent.registerMbeans();
            }
            lifeCycle.setStatus(RunStatus.RUNNING);
            lifeCycle.setStartUpTime(new Date().getTime());
            stopWatch.stop();
            Long initializationTime = stopWatch.getLastTaskTimeMillis();
            Log.info("Audit4j initialized. Total time: ", initializationTime, "ms");
        }
    }

    public static void initWithConfiguration(Configuration configuration) {
        Context.setConfig(configuration);
        Context.init();
    }

    public static void initWithConfiguration(String configFilePath) {
        Context.setConfigFilePath(configFilePath);
        Context.init();
    }

    static final void stop() {
        if (lifeCycle.getStatus().equals((Object)RunStatus.RUNNING) || lifeCycle.getStatus().equals((Object)RunStatus.DISABLED)) {
            lifeCycle.setStatus(RunStatus.STOPPED);
            Log.info((Object)"Preparing to shutdown Audit4j...");
            Log.info((Object)"Closing Streams...");
            auditStream.close();
            Log.info((Object)"Shutdown handlers...");
            for (Handler handler : configContext.getHandlers()) {
                handler.stop();
                Log.info((Object)(handler.getClass().getName() + " shutdown."));
            }
            Log.info((Object)"Disposing configurations...");
            configContext = null;
            conf = null;
            Log.info((Object)"Audit4j shutdown completed.");
        } else {
            Log.info((Object)"No active Audit4j instance. Cancelling shutdown request.");
        }
    }

    static final void enable() {
        if (lifeCycle.getStatus().equals((Object)RunStatus.READY) || lifeCycle.getStatus().equals((Object)RunStatus.STOPPED)) {
            Context.init();
        } else if (lifeCycle.getStatus().equals((Object)RunStatus.DISABLED)) {
            lifeCycle.setStatus(RunStatus.RUNNING);
        }
    }

    static final void disable() {
        Log.warn((Object)"Audit4j Disabled.!!");
        lifeCycle.setStatus(RunStatus.DISABLED);
    }

    static final void terminate() {
        Log.warn((Object)"Audit4j Terminated due to critical error.");
        lifeCycle.setStatus(RunStatus.TERMINATED);
    }

    static ConcurrentConfigurationContext getConfigContext() {
        return configContext;
    }

    private static final void checkEnvironment() {
        boolean javaSupport = EnvUtil.isJDK7OrHigher();
        if (!javaSupport) {
            Log.error("Your Java version (", EnvUtil.getJavaVersion(), ") is not supported for Audit4j. ", ErrorGuide.getGuide("http://audit4j.org/errors#javaVersion"));
            throw new InitializationException("Java version is not supported.");
        }
    }

    private static final void loadConfig() {
        try {
            conf = Configurations.loadConfig(configFilePath);
        }
        catch (ConfigurationException e) {
            Context.terminate();
            throw new InitializationException(INIT_FAILED, e);
        }
    }

    private static void loadRegistry() {
        for (AuditEventFilter filter : PreConfigurationContext.getPrefilters()) {
            configContext.addFilter(filter);
        }
        for (AuditAnnotationFilter annotationFilter : PreConfigurationContext.getPreannotationfilters()) {
            configContext.addAnnotationFilter(annotationFilter);
        }
    }

    private static void initHandlers() {
        Log.info((Object)"Initializing Handlers...");
        for (Handler handler : conf.getHandlers()) {
            try {
                if (!configContext.getHandlers().contains(handler)) {
                    HashMap<String, String> handlerproperties = new HashMap<String, String>();
                    handlerproperties.putAll(configContext.getProperties());
                    handler.setProperties(handlerproperties);
                    handler.init();
                    configContext.addHandler(handler);
                }
                Log.info((Object)(handler.getClass().getName() + " Initialized."));
            }
            catch (InitializationException e) {
                Log.error("There is a problem in the hander: ", handler.getClass().getName(), ErrorGuide.getGuide("http://audit4j.org/errors#handlerError"));
                Context.terminate();
                throw new InitializationException(INIT_FAILED, e);
            }
        }
    }

    private static void initLayout() {
        Log.info((Object)"Initializing Layout...");
        try {
            conf.getLayout().init();
            configContext.setLayout(conf.getLayout());
            Log.info((Object)(conf.getLayout().getClass().getName() + " Initialized."));
        }
        catch (InitializationException e) {
            Log.error("There is a problem in the layout: ", conf.getLayout().getClass().getName(), " you configured.", ErrorGuide.getGuide("http://audit4j.org/errors#layoutError"));
            Context.terminate();
            throw new InitializationException(INIT_FAILED);
        }
    }

    private static void initStreams() {
        Log.info((Object)"Initializing Streams...");
        MetadataCommand command = (MetadataCommand)PreConfigurationContext.getCommandByName("-metadata");
        BatchCommand batchCommand = (BatchCommand)PreConfigurationContext.getCommandByName("-batchSize");
        AsyncAnnotationAuditOutputStream asyncAnnotationStream = new AsyncAnnotationAuditOutputStream(new AuditProcessOutputStream(Context.getConfigContext()), annotationTransformer);
        AuditProcessOutputStream processStream = new AuditProcessOutputStream(Context.getConfigContext());
        if (command.isAsync()) {
            MetadataLookupStream metadataStream;
            if (batchCommand.getBatchSize() > 0) {
                BatchProcessStream batchStream = new BatchProcessStream(processStream, batchCommand.getBatchSize());
                metadataStream = new MetadataLookupStream(batchStream);
            } else {
                metadataStream = new MetadataLookupStream(processStream);
            }
            AsyncAuditOutputStream asyncStream = new AsyncAuditOutputStream(metadataStream, asyncAnnotationStream);
            auditStream = new AuditEventOutputStream(asyncStream, configContext);
        } else {
            AsyncAuditOutputStream asyncStream;
            if (batchCommand.getBatchSize() > 0) {
                BatchProcessStream batchStream = new BatchProcessStream(processStream, batchCommand.getBatchSize());
                asyncStream = new AsyncAuditOutputStream(batchStream, asyncAnnotationStream);
            } else {
                asyncStream = new AsyncAuditOutputStream(processStream, asyncAnnotationStream);
            }
            MetadataLookupStream metadataStream = new MetadataLookupStream(asyncStream);
            auditStream = new AuditEventOutputStream(metadataStream, configContext);
        }
        Log.info((Object)"Audit Streams Initialized.");
    }

    private static AnnotationTransformer<AuditEvent> getDefaultAnnotationTransformer() {
        DefaultAnnotationTransformer defaultAnnotationTransformer = new DefaultAnnotationTransformer();
        ObjectSerializerCommand serializerCommand = (ObjectSerializerCommand)PreConfigurationContext.getCommandByName("-objectSerializer");
        if (serializerCommand.getSerializer() == null) {
            defaultAnnotationTransformer.setSerializer(new ObjectToFieldsSerializer());
        } else {
            defaultAnnotationTransformer.setSerializer(serializerCommand.getSerializer());
        }
        return defaultAnnotationTransformer;
    }

    static final void setConfig(Configuration conf) {
        Context.conf = conf;
    }

    @Deprecated
    static Configuration getConfig() {
        return conf;
    }

    public static void setConfigFilePath(String configFilePath) {
        Context.configFilePath = configFilePath;
    }

    static final AuditOutputStream<AuditEvent> getAuditStream() {
        return auditStream;
    }

    public static RunStatus getStatus() {
        return lifeCycle.getStatus();
    }

    static {
        lifeCycle = LifeCycleContext.getInstance();
    }
}

