/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.audit4j.core.AnnotationTransformer;
import org.audit4j.core.ObjectSerializer;
import org.audit4j.core.ObjectToFieldsSerializer;
import org.audit4j.core.annotation.Audit;
import org.audit4j.core.annotation.AuditField;
import org.audit4j.core.annotation.DeIdentify;
import org.audit4j.core.annotation.IgnoreAudit;
import org.audit4j.core.dto.AnnotationAuditEvent;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.Field;

public class DefaultAnnotationTransformer
implements AnnotationTransformer<AuditEvent> {
    private static final String ACTION = "action";
    private ObjectSerializer serializer;

    public DefaultAnnotationTransformer() {
        this.serializer = new ObjectToFieldsSerializer();
    }

    public DefaultAnnotationTransformer(ObjectSerializer objectSerializer) {
        this.serializer = objectSerializer;
    }

    @Override
    public AuditEvent transformToEvent(AnnotationAuditEvent annotationEvent) {
        AuditEvent event = null;
        if (annotationEvent.getClazz().isAnnotationPresent(Audit.class) && !annotationEvent.getMethod().isAnnotationPresent(IgnoreAudit.class)) {
            event = new AuditEvent();
            Audit audit = annotationEvent.getClazz().getAnnotation(Audit.class);
            event.setFields(this.getFields(annotationEvent.getMethod(), annotationEvent.getArgs()));
            String annotationAction = audit.action();
            if (ACTION.equals(annotationAction)) {
                event.setAction(annotationEvent.getMethod().getName());
            } else {
                event.setAction(annotationAction);
            }
            event.setRepository(audit.repository());
            event.setActor(annotationEvent.getActor());
            event.setOrigin(annotationEvent.getOrigin());
        } else if (!annotationEvent.getClazz().isAnnotationPresent(Audit.class) && annotationEvent.getMethod().isAnnotationPresent(Audit.class)) {
            event = new AuditEvent();
            Audit audit = annotationEvent.getMethod().getAnnotation(Audit.class);
            event.setFields(this.getFields(annotationEvent.getMethod(), annotationEvent.getArgs()));
            String annotationAction = audit.action();
            if (ACTION.equals(annotationAction)) {
                event.setAction(annotationEvent.getMethod().getName());
            } else {
                event.setAction(annotationAction);
            }
            event.setRepository(audit.repository());
            event.setActor(annotationEvent.getActor());
            event.setOrigin(annotationEvent.getOrigin());
        }
        return event;
    }

    private List<Field> getFields(Method method, Object[] params) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<Field> fields = new ArrayList<Field>();
        int i = 0;
        String paramName = null;
        for (Annotation[] annotations : parameterAnnotations) {
            Object object = params[i++];
            boolean ignoreFlag = false;
            DeIdentify deidentify = null;
            for (Annotation annotation : annotations) {
                if (annotation instanceof IgnoreAudit) {
                    ignoreFlag = true;
                    break;
                }
                if (annotation instanceof AuditField) {
                    AuditField field = (AuditField)annotation;
                    paramName = field.field();
                }
                if (!(annotation instanceof DeIdentify)) continue;
                deidentify = (DeIdentify)annotation;
            }
            if (!ignoreFlag) {
                if (null == paramName) {
                    paramName = "arg" + i;
                }
                this.serializer.serialize(fields, object, paramName, deidentify);
            }
            paramName = null;
        }
        return fields;
    }

    public void setSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }
}

