/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.audit4j.core.ObjectSerializer;
import org.audit4j.core.annotation.DeIdentify;
import org.audit4j.core.annotation.DeIdentifyUtil;
import org.audit4j.core.annotation.IgnoreAudit;
import org.audit4j.core.dto.Field;
import org.audit4j.core.exception.Audit4jRuntimeException;

public final class ObjectToFieldsSerializer
implements ObjectSerializer {
    private static final ArrayList<Object> visited = new ArrayList();

    public final void toFields(List<Field> auditFields, Object object, String objectName, DeIdentify deidentify) {
        String localOjectName = objectName;
        if (object == null) {
            auditFields.add(new Field(localOjectName, "null"));
            return;
        }
        Class<?> clazz = object.getClass();
        if (!visited.contains(object)) {
            visited.add(object);
            if (ObjectToFieldsSerializer.isPrimitive(object)) {
                String primitiveValue = String.valueOf(object);
                if (deidentify != null) {
                    primitiveValue = DeIdentifyUtil.deidentify(primitiveValue, deidentify.left(), deidentify.right(), deidentify.fromLeft(), deidentify.fromRight());
                }
                auditFields.add(new Field(localOjectName, primitiveValue, object.getClass().getName()));
            } else if (clazz.isArray()) {
                if (Array.getLength(object) == 0) {
                    auditFields.add(new Field(localOjectName + '$' + clazz.getName(), "<empty>"));
                } else {
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object objVal = Array.get(object, i);
                        String internalLocalOjectName = localOjectName + '{' + "arg" + i + '}';
                        if (clazz.getComponentType().isPrimitive()) {
                            auditFields.add(new Field(internalLocalOjectName, String.valueOf(objVal), objVal.getClass().getName()));
                            continue;
                        }
                        if (objVal == null) continue;
                        this.toFields(auditFields, objVal, internalLocalOjectName, null);
                    }
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                if (collection.isEmpty()) {
                    auditFields.add(new Field(localOjectName + '$' + clazz.getName(), "<empty>"));
                } else {
                    String internalLocalOjectName = localOjectName + '$' + object.getClass().getName();
                    int i = 0;
                    for (Object collectionObject : collection) {
                        String internalLocalOjectName2 = internalLocalOjectName + '{' + "arg" + i + '}';
                        if (ObjectToFieldsSerializer.isPrimitive(collectionObject)) {
                            auditFields.add(new Field(internalLocalOjectName2, String.valueOf(collectionObject), collectionObject.getClass().getName()));
                        } else if (collectionObject != null) {
                            this.toFields(auditFields, collectionObject, internalLocalOjectName2, null);
                        }
                        ++i;
                    }
                }
            } else {
                String internalLocalOjectName = localOjectName + '$' + clazz.getName();
                do {
                    AccessibleObject[] fields = clazz.getDeclaredFields();
                    AccessibleObject.setAccessible(fields, true);
                    for (AccessibleObject field : fields) {
                        if (Modifier.isStatic(((java.lang.reflect.Field)field).getModifiers()) || field.isAnnotationPresent(IgnoreAudit.class)) continue;
                        String internalLocalOjectName2 = internalLocalOjectName + '$' + ((java.lang.reflect.Field)field).getName();
                        boolean deidentifyFlag = false;
                        DeIdentify deidentifyAnn = null;
                        if (field.isAnnotationPresent(DeIdentify.class)) {
                            deidentifyAnn = ((java.lang.reflect.Field)field).getAnnotation(DeIdentify.class);
                            deidentifyFlag = true;
                        }
                        try {
                            Object objValue = ((java.lang.reflect.Field)field).get(object);
                            if (ObjectToFieldsSerializer.isPrimitive(object)) {
                                String paramValue = String.valueOf(object);
                                if (deidentifyFlag) {
                                    paramValue = DeIdentifyUtil.deidentify(paramValue, deidentifyAnn.left(), deidentifyAnn.right(), deidentifyAnn.fromLeft(), deidentifyAnn.fromRight());
                                }
                                auditFields.add(new Field(internalLocalOjectName2, paramValue, object.getClass().getName()));
                                continue;
                            }
                            if (objValue == null) continue;
                            this.toFields(auditFields, objValue, internalLocalOjectName2, deidentifyAnn);
                        }
                        catch (IllegalArgumentException e) {
                            throw new Audit4jRuntimeException("Error due to converting object to string representation. ", e);
                        }
                        catch (IllegalAccessException e) {
                            throw new Audit4jRuntimeException("Error due to converting object to string representation. ", e);
                        }
                        catch (Exception e) {
                            throw new Audit4jRuntimeException("Error due to converting object to string representation. ", e);
                        }
                    }
                } while ((clazz = clazz.getSuperclass()) != null);
            }
        }
    }

    @Override
    public void serialize(List<Field> auditFields, Object object, String objectName, DeIdentify deidentify) {
        visited.clear();
        this.toFields(auditFields, object, objectName, deidentify);
    }

    public static final boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character;
    }
}

