/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.audit4j.core.ObjectSerializer;
import org.audit4j.core.annotation.DeIdentify;
import org.audit4j.core.annotation.DeIdentifyUtil;
import org.audit4j.core.annotation.IgnoreAudit;
import org.audit4j.core.dto.Field;

public final class ObjectToJsonSerializer
implements ObjectSerializer {
    @Override
    public void serialize(List<Field> auditFields, Object object, String objectName, DeIdentify deidentify) {
        String name = '\"' + objectName + '\"';
        String json = ObjectToJsonSerializer.toJson(object, deidentify);
        String fieldType = object == null ? "null" : object.getClass().getName();
        auditFields.add(new Field(name, json, fieldType));
    }

    public static final String toJson(Object object, DeIdentify deidentify) {
        if (ObjectToJsonSerializer.isPrimitive(object)) {
            Object deidentifiedObj = ObjectToJsonSerializer.deidentifyObject(object, deidentify);
            String primitiveValue = String.valueOf(deidentifiedObj);
            if (object instanceof String || object instanceof Character || !object.equals(deidentifiedObj)) {
                primitiveValue = '\"' + primitiveValue + '\"';
            }
            return primitiveValue;
        }
        return JSON.toJSONString((Object)object, (SerializeFilter)JsonFilter.INSTANCE, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static final boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character;
    }

    public static final Object deidentifyObject(Object object, DeIdentify deidentify) {
        if (object == null || deidentify == null) {
            return object;
        }
        return DeIdentifyUtil.deidentify(String.valueOf(object), deidentify.left(), deidentify.right(), deidentify.fromLeft(), deidentify.fromRight());
    }

    static class JsonFilter
    implements PropertyFilter,
    ValueFilter {
        private static final ConcurrentMap<String, Map<String, DeIdentify>> DEIDENTIFY_CACHE = new ConcurrentHashMap<String, Map<String, DeIdentify>>();
        private static final ConcurrentMap<String, Map<String, Boolean>> IGNORE_AUDIT_CACHE = new ConcurrentHashMap<String, Map<String, Boolean>>();
        static final JsonFilter INSTANCE = new JsonFilter();

        private JsonFilter() {
        }

        public Object process(Object object, String name, Object value) {
            Class<?> clazz = object.getClass();
            String key = clazz.getName();
            Map deidentifyMap = (Map)DEIDENTIFY_CACHE.get(key);
            if (deidentifyMap == null) {
                DEIDENTIFY_CACHE.putIfAbsent(key, JsonFilter.createDeIdentifyMapping(clazz));
                deidentifyMap = (Map)DEIDENTIFY_CACHE.get(key);
            }
            return ObjectToJsonSerializer.deidentifyObject(value, (DeIdentify)deidentifyMap.get(name));
        }

        public boolean apply(Object object, String name, Object value) {
            Class<?> clazz = object.getClass();
            String key = clazz.getName();
            Map ignoreAuditMap = (Map)IGNORE_AUDIT_CACHE.get(key);
            if (ignoreAuditMap == null) {
                IGNORE_AUDIT_CACHE.putIfAbsent(key, JsonFilter.createIgnoreAuditMapping(clazz));
                ignoreAuditMap = (Map)IGNORE_AUDIT_CACHE.get(key);
            }
            return !Boolean.TRUE.equals(ignoreAuditMap.get(name));
        }

        private static Map<String, DeIdentify> createDeIdentifyMapping(Class<?> clazz) {
            Map<String, DeIdentify> mapping = new HashMap<String, DeIdentify>();
            for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(DeIdentify.class)) continue;
                mapping.put(field.getName(), field.getAnnotation(DeIdentify.class));
            }
            if (mapping.isEmpty()) {
                mapping = Collections.emptyMap();
            }
            return mapping;
        }

        private static Map<String, Boolean> createIgnoreAuditMapping(Class<?> clazz) {
            Map<String, Boolean> mapping = new HashMap<String, Boolean>();
            for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(IgnoreAudit.class)) continue;
                mapping.put(field.getName(), Boolean.TRUE);
            }
            if (mapping.isEmpty()) {
                mapping = Collections.emptyMap();
            }
            return mapping;
        }
    }
}

