/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.audit4j.core.ObjectSerializer;
import org.audit4j.core.annotation.DeIdentify;
import org.audit4j.core.annotation.DeIdentifyUtil;
import org.audit4j.core.annotation.IgnoreAudit;
import org.audit4j.core.dto.Field;
import org.audit4j.core.exception.Audit4jRuntimeException;

public final class ObjectToStringSerializer
implements ObjectSerializer {
    private static final ArrayList<Object> visited = new ArrayList();

    @Override
    public void serialize(List<Field> auditFields, Object object, String objectName, DeIdentify deidentify) {
        visited.clear();
        String text = ObjectToStringSerializer.toString(object, deidentify);
        auditFields.add(new Field(objectName, text, object.getClass().getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String toString(Object object, DeIdentify deidentify) {
        StringBuilder builder = new StringBuilder();
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (ObjectToStringSerializer.isPrimitive(object)) {
            String primitiveValue = String.valueOf(object);
            if (deidentify == null) return primitiveValue;
            return DeIdentifyUtil.deidentify(primitiveValue, deidentify.left(), deidentify.right(), deidentify.fromLeft(), deidentify.fromRight());
        }
        if (visited.contains(object)) {
            return "...";
        }
        visited.add(object);
        if (clazz.isArray()) {
            if (Array.getLength(object) == 0) {
                builder.append(clazz.getComponentType()).append("[]");
                return builder.toString();
            }
            builder.append(clazz.getComponentType()).append("[]").append('{');
            int i = 0;
            while (i < Array.getLength(object)) {
                if (i > 0) {
                    builder.append(',');
                }
                Object objVal = Array.get(object, i);
                if (clazz.getComponentType().isPrimitive()) {
                    builder.append(objVal);
                } else {
                    builder.append(ObjectToStringSerializer.toString(objVal, null));
                }
                ++i;
            }
            return builder.append('}').toString();
        }
        builder.append(clazz.getName());
        do {
            builder.append('[');
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                String paramValue;
                if (Modifier.isStatic(((java.lang.reflect.Field)field).getModifiers()) || field.isAnnotationPresent(IgnoreAudit.class)) continue;
                if (!builder.toString().endsWith(String.valueOf('['))) {
                    builder.append(',');
                }
                builder.append(((java.lang.reflect.Field)field).getName()).append('=');
                try {
                    Object objValue = ((java.lang.reflect.Field)field).get(object);
                    paramValue = ObjectToStringSerializer.isPrimitive(object) ? String.valueOf(object) : ObjectToStringSerializer.toString(objValue, null);
                }
                catch (IllegalArgumentException e) {
                    throw new Audit4jRuntimeException("Error due to converting object to string representation. ", e);
                }
                catch (IllegalAccessException e) {
                    throw new Audit4jRuntimeException("Error due to converting object to string representation. ", e);
                }
                catch (Exception e) {
                    throw new Audit4jRuntimeException("Error due to converting object to string representation. ", e);
                }
                if (field.isAnnotationPresent(DeIdentify.class)) {
                    DeIdentify deidentifyAnn = ((java.lang.reflect.Field)field).getAnnotation(DeIdentify.class);
                    paramValue = DeIdentifyUtil.deidentify(paramValue, deidentifyAnn.left(), deidentifyAnn.right(), deidentifyAnn.fromLeft(), deidentifyAnn.fromRight());
                }
                builder.append(paramValue);
            }
            builder.append(']');
        } while ((clazz = clazz.getSuperclass()) != null);
        return builder.toString();
    }

    public static final boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character;
    }
}

