/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.audit4j.core.command.AbstractCommand;
import org.audit4j.core.command.impl.BatchCommand;
import org.audit4j.core.command.impl.MetadataCommand;
import org.audit4j.core.command.impl.ObjectSerializerCommand;
import org.audit4j.core.command.impl.ScanAnnotatedCommand;
import org.audit4j.core.filter.AuditAnnotationFilter;
import org.audit4j.core.filter.AuditEventFilter;

public final class PreConfigurationContext {
    private static final Map<String, AbstractCommand> commands = new HashMap<String, AbstractCommand>();
    private static final List<String> availableCommands = new ArrayList<String>();
    private static final List<AuditEventFilter> preFilters = new ArrayList<AuditEventFilter>();
    private static final List<AuditAnnotationFilter> preAnnotationFilters = new ArrayList<AuditAnnotationFilter>();

    private PreConfigurationContext() {
    }

    public static AbstractCommand getCommandByName(String commandName) {
        return commands.get(commandName);
    }

    public static List<String> getAvailableCommands() {
        return availableCommands;
    }

    public static Map<String, AbstractCommand> getCommands() {
        return commands;
    }

    public static List<AuditEventFilter> getPrefilters() {
        return preFilters;
    }

    public static void addFilter(AuditEventFilter filter) {
        preFilters.add(filter);
    }

    public static void addAnnotationFilter(AuditAnnotationFilter filter) {
        preAnnotationFilters.add(filter);
    }

    public static List<AuditAnnotationFilter> getPreannotationfilters() {
        return preAnnotationFilters;
    }

    static {
        ScanAnnotatedCommand scanAnnotated = new ScanAnnotatedCommand();
        availableCommands.add(scanAnnotated.getCommand());
        commands.put(scanAnnotated.getCommand(), scanAnnotated);
        MetadataCommand metadataCommand = new MetadataCommand();
        availableCommands.add(metadataCommand.getCommand());
        commands.put(metadataCommand.getCommand(), metadataCommand);
        ObjectSerializerCommand serializerCommand = new ObjectSerializerCommand();
        availableCommands.add(serializerCommand.getCommand());
        commands.put(serializerCommand.getCommand(), serializerCommand);
        BatchCommand batchCommand = new BatchCommand();
        availableCommands.add(batchCommand.getCommand());
        commands.put(batchCommand.getCommand(), batchCommand);
    }
}

