/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.audit4j.core.Configuration;
import org.audit4j.core.ErrorGuide;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.exception.ValidationException;
import org.audit4j.core.handler.file.FileAuditHandler;
import org.audit4j.core.util.Log;

public final class ValidationManager {
    private ValidationManager() {
    }

    public static void validateEvent(AuditEvent event) throws ValidationException {
        if (event == null) {
            throw new ValidationException("Invalid Input", "WARN");
        }
    }

    static void validateConfigurations(Configuration conf) throws ValidationException {
        if (null == conf.getHandlers()) {
            Log.error("Handler should not be null, One or more handler implementation shuld be configured in the configuration", ErrorGuide.getGuide("http://audit4j.org/errors#noHandlers"));
            throw new ValidationException("Configuration error", "INVALID");
        }
        if (null == conf.getLayout()) {
            Log.error("Layout should not be null, A layout implementation shuld be configured in the configuration", ErrorGuide.getGuide("http://audit4j.org/errors#noLayout"));
            throw new ValidationException("Configuration error", "INVALID");
        }
    }

    static boolean isSerializable(Object object) {
        boolean retVal = ValidationManager.implementsInterface(object) ? ValidationManager.attemptToSerialize(object) : false;
        return retVal;
    }

    private static boolean implementsInterface(Object o) {
        boolean retVal = o instanceof Serializable || o instanceof Externalizable;
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean attemptToSerialize(Object o) {
        ObjectOutputStream stream = null;
        try {
            ByteArrayOutputStream sink = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(sink);
            stream.writeObject(o);
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(ValidationManager.isSerializable(new FileAuditHandler()));
    }
}

