/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.audit4j.core.ConfigProvider;
import org.audit4j.core.exception.ConfigurationException;

public class XMLConfigProvider<T>
implements ConfigProvider<T> {
    private final Class<T> clazz;

    public XMLConfigProvider(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T readConfig(String filePath) throws ConfigurationException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.alias("configuration", this.clazz);
        return (T)xstream.fromXML(new File(filePath));
    }

    @Override
    public T readConfig(InputStream fileAsStream) throws ConfigurationException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.alias("configuration", this.clazz);
        return (T)xstream.fromXML(fileAsStream);
    }

    @Override
    public void generateConfig(T config, String filePath) throws ConfigurationException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.alias("configuration", this.clazz);
        BufferedOutputStream stdout = null;
        try {
            stdout = new BufferedOutputStream(new FileOutputStream(filePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        xstream.marshal(config, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)new OutputStreamWriter(stdout)));
    }
}

