/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.audit4j.core.ConfigProvider;
import org.audit4j.core.Configuration;
import org.audit4j.core.exception.ConfigurationException;

public class YAMLConfigProvider<T>
implements ConfigProvider<T> {
    private final Class<T> clazz;

    public YAMLConfigProvider(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T readConfig(String filePath) throws ConfigurationException {
        try {
            YamlReader reader = new YamlReader((Reader)new FileReader(filePath));
            reader.getConfig().setClassTag(this.clazz.getSimpleName(), this.clazz);
            return (T)reader.read();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Configuration Exception", "CONF_001", e);
        }
        catch (YamlException e) {
            throw new ConfigurationException("Configuration Exception", "CONF_002", e);
        }
    }

    @Override
    public T readConfig(InputStream fileAsStream) throws ConfigurationException {
        InputStreamReader streamReader = new InputStreamReader(fileAsStream);
        try {
            YamlReader reader = new YamlReader((Reader)streamReader);
            reader.getConfig().setClassTag(this.clazz.getSimpleName(), this.clazz);
            return (T)reader.read();
        }
        catch (YamlException e) {
            throw new ConfigurationException("Configuration Exception", "CONF_002", e);
        }
    }

    @Override
    public void generateConfig(T config, String filePath) throws ConfigurationException {
        try {
            YamlWriter writer = new YamlWriter((Writer)new FileWriter(filePath));
            writer.getConfig().setClassTag(this.clazz.getSimpleName(), this.clazz);
            writer.write((Object)Configuration.DEFAULT);
            writer.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration Exception", "CONF_002");
        }
    }
}

