/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.annotation;

import org.apache.commons.lang3.StringUtils;

public class DeIdentifyUtil {
    private DeIdentifyUtil() {
    }

    public static String deidentifyLeft(String str, int size) {
        int repeat = size > str.length() ? str.length() : size;
        return StringUtils.overlay((String)str, (String)StringUtils.repeat((char)'*', (int)repeat), (int)0, (int)size);
    }

    public static String deidentifyRight(String str, int size) {
        int end = str.length();
        int repeat = size > str.length() ? str.length() : size;
        return StringUtils.overlay((String)str, (String)StringUtils.repeat((char)'*', (int)repeat), (int)(end - size), (int)end);
    }

    public static String deidentifyFromLeft(String str, int size) {
        int end = str.length();
        int repeat = size > str.length() ? 0 : str.length() - size;
        return StringUtils.overlay((String)str, (String)StringUtils.repeat((char)'*', (int)repeat), (int)size, (int)end);
    }

    public static String deidentifyFromRight(String str, int size) {
        int end = str.length();
        int repeat = size > str.length() ? str.length() : end - size;
        return StringUtils.overlay((String)str, (String)StringUtils.repeat((char)'*', (int)repeat), (int)0, (int)(end - size));
    }

    public static String deidentifyMiddle(String str, int start, int end) {
        int repeat = end - start > str.length() ? str.length() : str.length() - end - start;
        return StringUtils.overlay((String)str, (String)StringUtils.repeat((char)'*', (int)repeat), (int)start, (int)(str.length() - end));
    }

    public static String deidentifyEdge(String str, int start, int end) {
        return DeIdentifyUtil.deidentifyLeft(DeIdentifyUtil.deidentifyRight(str, end), start);
    }

    public static String deidentify(String text, int left, int right, int fromLeft, int fromRight) {
        if (left == 0 && right == 0 && fromLeft == 0 && fromRight == 0) {
            return StringUtils.repeat((char)'*', (int)text.length());
        }
        if (left > 0 && right == 0 && fromLeft == 0 && fromRight == 0) {
            return DeIdentifyUtil.deidentifyLeft(text, left);
        }
        if (left == 0 && right > 0 && fromLeft == 0 && fromRight == 0) {
            return DeIdentifyUtil.deidentifyRight(text, right);
        }
        if (left > 0 && right > 0 && fromLeft == 0 && fromRight == 0) {
            return DeIdentifyUtil.deidentifyEdge(text, left, right);
        }
        if (left == 0 && right == 0 && fromLeft > 0 && fromRight == 0) {
            return DeIdentifyUtil.deidentifyFromLeft(text, fromLeft);
        }
        if (left == 0 && right == 0 && fromLeft == 0 && fromRight > 0) {
            return DeIdentifyUtil.deidentifyFromRight(text, fromRight);
        }
        if (left == 0 && right == 0 && fromLeft > 0 && fromRight > 0) {
            return DeIdentifyUtil.deidentifyMiddle(text, fromLeft, fromRight);
        }
        return text;
    }
}

