/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.command;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.audit4j.core.ErrorGuide;
import org.audit4j.core.PreConfigurationContext;
import org.audit4j.core.command.AbstractCommand;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.util.Log;

public final class CommandProcessor {
    private static CommandProcessor instance;

    private CommandProcessor() {
    }

    public void process(Map<String, String> options) {
        Log.info((Object)"Initializing Commands...");
        for (Map.Entry<String, String> entry : options.entrySet()) {
            AbstractCommand command = PreConfigurationContext.getCommandByName(entry.getKey());
            if (null != command) {
                command.setCommands(options);
                try {
                    command.init();
                }
                catch (InitializationException e) {
                    Log.error("There is a problem in the option you configured: ", entry.getKey(), ErrorGuide.getGuide("http://audit4j.org/errors#optionError"));
                }
                command.execute();
                command.stop();
            }
            Log.info((Object)(entry.getKey() + " Command Initialized."));
        }
    }

    public void process(String commandText) {
        String[] args;
        if (commandText == null || commandText.isEmpty()) {
            return;
        }
        HashMap<String, String> commands = new HashMap<String, String>();
        for (String arg : args = StringUtils.split((String)commandText)) {
            String[] command = StringUtils.split((String)arg, (char)'=');
            if (!PreConfigurationContext.getAvailableCommands().contains(command[0])) {
                Log.warn("Invalid command: ", command[0], " Please check your configurations. ", ErrorGuide.getGuide("http://audit4j.org/errors#invalidCommand"));
            }
            commands.put(command[0], command[1]);
        }
        this.process(commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommandProcessor getInstance() {
        if (null != instance) return instance;
        Class<CommandProcessor> clazz = CommandProcessor.class;
        synchronized (CommandProcessor.class) {
            if (null != instance) return instance;
            instance = new CommandProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

