/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.command.impl;

import org.audit4j.core.ObjectSerializer;
import org.audit4j.core.command.AbstractCommand;
import org.audit4j.core.exception.InitializationException;

public class ObjectSerializerCommand
extends AbstractCommand {
    private ObjectSerializer serializer = null;

    @Override
    public void init() throws InitializationException {
        String rawClass = this.getOptionByCommand(this.getCommand());
        try {
            Class<?> clazz = Class.forName(rawClass);
            this.serializer = (ObjectSerializer)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new InitializationException("Given serializer class name not supported.!", e);
        }
    }

    public ObjectSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void stop() {
    }

    @Override
    public void execute() {
    }

    @Override
    public String getCommand() {
        return "-objectSerializer";
    }

    @Override
    public String getCommandDescription() {
        return "Sets Custom Serializer implementation ";
    }
}

