/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.command.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.audit4j.core.PreConfigurationContext;
import org.audit4j.core.annotation.Audit;
import org.audit4j.core.command.AbstractCommand;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.extra.scannotation.AnnotationDB;
import org.audit4j.core.filter.impl.ScanAnnotatedFilter;

public class ScanAnnotatedCommand
extends AbstractCommand {
    AnnotationDB db;

    @Override
    public String getCommand() {
        return "-scanAnnotated";
    }

    @Override
    public String getCommandDescription() {
        return "Scan annotations in initialization time and store the information. These information will use later to speedup the event processing";
    }

    @Override
    public void init() {
        String packageName = this.getCommands().get(this.getCommand());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        URL url = null;
        try {
            Enumeration<URL> urls = classLoader.getResources(path);
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                int index = url.toExternalForm().lastIndexOf(path);
                url = new URL(url.toExternalForm().substring(0, index));
            }
        }
        catch (IOException e) {
            throw new InitializationException("", e);
        }
        this.db = new AnnotationDB();
        this.db.setScanClassAnnotations(true);
        this.db.setScanMethodAnnotations(true);
        try {
            this.db.scanArchives(url);
        }
        catch (IOException e) {
            throw new InitializationException("", e);
        }
    }

    @Override
    public void execute() {
        Set<String> annotated = this.db.getAnnotationIndex().get(Audit.class.getName());
        ScanAnnotatedFilter filter = new ScanAnnotatedFilter();
        for (String annotaionClass : annotated) {
            try {
                Class<?> clazz = Class.forName(annotaionClass);
                filter.addClass(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new InitializationException("", e);
            }
        }
        PreConfigurationContext.addAnnotationFilter(filter);
    }

    @Override
    public void stop() {
        this.db = null;
    }
}

