/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.dto;

import java.util.ArrayList;
import java.util.List;
import org.audit4j.core.dto.Event;
import org.audit4j.core.dto.Field;

public class AuditEvent
extends Event {
    private static final long serialVersionUID = -7009763987501353992L;
    private String actor;
    private String origin;
    private String action;
    private List<Field> fields = new ArrayList<Field>();
    private String tag;
    private String repository;

    public AuditEvent() {
    }

    public AuditEvent(String actor, String action, Field ... fields) {
        this.actor = actor;
        this.action = action;
        for (Field field : fields) {
            this.addField(field);
        }
    }

    public AuditEvent(String actor, String action, String origin, Field ... fields) {
        this.actor = actor;
        this.action = action;
        this.origin = origin;
        for (Field field : fields) {
            this.addField(field);
        }
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void addField(String name, Object value, Object type) {
        if (value == null) {
            this.fields.add(new Field(name, null, null));
        } else {
            this.fields.add(new Field(name, value.toString(), type.toString()));
        }
    }

    public void addField(String name, Object value) {
        if (value == null) {
            this.fields.add(new Field(name, null, null));
        } else {
            this.fields.add(new Field(name, value.toString(), value.getClass().getName()));
        }
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(String repository) {
        this.repository = repository;
    }
}

