/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.audit4j.core.dto.Event;

public class EventBatch<T extends Event>
implements Iterable<T> {
    private List<T> events = new ArrayList<T>();

    public EventBatch() {
    }

    public EventBatch(T ... events) {
        Collections.addAll(this.events, events);
    }

    public EventBatch(List<T> events) {
        this.events = events;
    }

    public void addEvent(T event) {
        this.events.add(event);
    }

    public void removeEvent(T event) {
        this.events.remove(event);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public long size() {
        return this.events.size();
    }

    public Event get(int index) {
        return (Event)this.events.get(index);
    }

    @Override
    public Iterator iterator() {
        return this.events.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBatch batch = (EventBatch)o;
        return this.events.equals(batch.events);
    }

    public int hashCode() {
        return this.events.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Batch: {");
        stringBuilder.append("|");
        for (Event event : this.events) {
            stringBuilder.append('\t');
            stringBuilder.append(event);
            stringBuilder.append("|");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

