/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.extra.scannotation;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.audit4j.core.extra.scannotation.DirectoryIteratorFactory;
import org.audit4j.core.extra.scannotation.FileIterator;
import org.audit4j.core.extra.scannotation.Filter;
import org.audit4j.core.extra.scannotation.JarIterator;
import org.audit4j.core.extra.scannotation.StreamIterator;

public class FileProtocolIteratorFactory
implements DirectoryIteratorFactory {
    @Override
    public StreamIterator create(URL url, Filter filter) throws IOException {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        if (f.isDirectory()) {
            return new FileIterator(f, filter);
        }
        return new JarIterator(url.openStream(), filter);
    }
}

