/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.extra.scannotation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.audit4j.core.extra.scannotation.Filter;
import org.audit4j.core.extra.scannotation.InputStreamWrapper;
import org.audit4j.core.extra.scannotation.StreamIterator;

public class JarIterator
implements StreamIterator {
    JarInputStream jar;
    JarEntry next;
    Filter filter;
    boolean initial = true;
    boolean closed = false;

    public JarIterator(File file, Filter filter) throws IOException {
        this(new FileInputStream(file), filter);
    }

    public JarIterator(InputStream is, Filter filter) throws IOException {
        this.filter = filter;
        this.jar = new JarInputStream(is);
    }

    private void setNext() {
        this.initial = true;
        try {
            if (this.next != null) {
                this.jar.closeEntry();
            }
            this.next = null;
            do {
                this.next = this.jar.getNextJarEntry();
            } while (this.next != null && (this.next.isDirectory() || this.filter == null || !this.filter.accepts(this.next.getName())));
            if (this.next == null) {
                this.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed to browse jar", e);
        }
    }

    @Override
    public InputStream next() {
        if (this.closed || this.next == null && !this.initial) {
            return null;
        }
        this.setNext();
        if (this.next == null) {
            return null;
        }
        return new InputStreamWrapper(this.jar);
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            this.jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

