/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file;

import java.io.FilePermission;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.exception.HandlerException;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.handler.file.AuditFileWriter;
import org.audit4j.core.handler.file.ZeroCopyFileWriter;
import org.audit4j.core.handler.file.archive.AbstractArchiveJob;

public class FileAuditHandler
extends Handler
implements Serializable {
    private static final long serialVersionUID = -1137506723185823390L;
    AuditFileWriter writer;
    private String archive;
    private String datePattern;
    private String path;
    private String cronPattern;
    private AbstractArchiveJob job;
    private String auditFilePrefix = "Audit_Log-";

    @Override
    public void init() throws InitializationException {
        this.writer = new ZeroCopyFileWriter(this.getProperty("log.file.location"));
        this.writer.init();
    }

    @Override
    public void handle() {
        this.writer.write(this.getQuery());
    }

    static boolean hasDiskAccess(String path) {
        try {
            AccessController.checkPermission(new FilePermission(path, "read,write"));
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setCronPattern(String cronPattern) {
        this.cronPattern = cronPattern;
    }

    public void setAuditFilePrefix(String auditFilePrefix) {
        this.auditFilePrefix = auditFilePrefix;
    }

    @Override
    public void stop() {
        this.writer.stop();
    }

    @Override
    public void handle(String formattedEvent) throws HandlerException {
    }

    public void handle(AuditEvent event) throws HandlerException {
    }

    public void handle(EventBatch batch) throws HandlerException {
    }
}

