/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.audit4j.core.util.AuditUtil;
import org.audit4j.core.util.EnvUtil;

public final class FileHandlerUtil {
    private FileHandlerUtil() {
    }

    @Deprecated
    public static String generateOutputFilePath(String path) {
        String tempPath = FileHandlerUtil.separatorsToSystem(path);
        tempPath = tempPath + File.separatorChar + FileHandlerUtil.generateAuditFileName();
        return tempPath;
    }

    public static String generateOutputFilePath(String path, String fileName) {
        String tempPath = FileHandlerUtil.separatorsToSystem(path);
        tempPath = tempPath + File.separatorChar + fileName;
        return tempPath;
    }

    public static String generatePreviousPreviousFileName() {
        StringBuffer name = new StringBuffer();
        name.append("Audit_Log-").append(AuditUtil.dateToString(new Date(), "yyyy-MM-dd")).append(".audit");
        return name.toString();
    }

    public static String generateAuditFileName() {
        StringBuffer name = new StringBuffer();
        name.append("Audit_Log-").append(AuditUtil.dateToString(new Date(), "yyyy-MM-dd")).append(".audit");
        return name.toString();
    }

    public static String generateAuditArchiveFileName(Date date) {
        StringBuffer name = new StringBuffer();
        name.append("Audit_Archive-").append(AuditUtil.dateToString(date, "yyyy-MM-dd")).append(".auditarchive");
        return name.toString();
    }

    public static String generateAuditFileName(Date date) {
        StringBuffer name = new StringBuffer();
        name.append("Audit_Log-").append(AuditUtil.dateToString(date, "yyyy-MM-dd")).append(".audit");
        return name.toString();
    }

    public static String generateCommonFileName(Date date) {
        StringBuffer name = new StringBuffer();
        name.append("Audit_Log-").append(AuditUtil.dateToString(date, "yyyy-MM-dd"));
        return name.toString();
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static String separatorsToWindows(String path) {
        if (path == null || path.indexOf(47) == -1) {
            return path;
        }
        return path.replace('/', '\\');
    }

    public static String separatorsToSystem(String path) {
        if (path == null) {
            return null;
        }
        if (EnvUtil.isWindows()) {
            return FileHandlerUtil.separatorsToWindows(path);
        }
        return FileHandlerUtil.separatorsToUnix(path);
    }

    public static boolean isFileAlreadyExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static Date addDate(Date date, Integer different) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, different);
        return cal.getTime();
    }

    public static Date substractDate(Date date, Integer different) {
        return FileHandlerUtil.addDate(date, -different.intValue());
    }
}

