/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.audit4j.core.handler.file.AuditFileWriter;
import org.audit4j.core.handler.file.FileHandlerUtil;

public class MemoryMappedFileWriter
extends AuditFileWriter
implements Serializable {
    private final String path;
    MappedByteBuffer out;

    public MemoryMappedFileWriter(String path) {
        this.path = path;
    }

    @Override
    public void init() {
        int count = 0xA00000;
        String realPath = FileHandlerUtil.generateOutputFilePath(this.path);
        try {
            RandomAccessFile randomAccessFile = FileHandlerUtil.isFileAlreadyExists(realPath) ? new RandomAccessFile(realPath, "rw") : new RandomAccessFile(new File(realPath), "rw");
            randomAccessFile.seek(randomAccessFile.length());
            this.out = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, count);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AuditFileWriter write(String event) {
        String str2 = event + "\n";
        this.out.put(str2.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    @Override
    public void stop() {
    }
}

