/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.audit4j.core.handler.file.AuditFileWriter;
import org.audit4j.core.handler.file.FileHandlerUtil;

public final class ZeroCopyFileWriter
extends AuditFileWriter
implements Serializable {
    private static final long serialVersionUID = -1982643461500366178L;
    RandomAccessFile randomAccessFile;
    FileChannel fileChannel;
    private final String path;
    String lastRealPath;

    public ZeroCopyFileWriter(String path) {
        this.path = path;
    }

    @Override
    public void init() {
    }

    @Override
    public ZeroCopyFileWriter write(String event) {
        String realPath = FileHandlerUtil.generateOutputFilePath(this.path, FileHandlerUtil.generateAuditFileName());
        try {
            if (this.randomAccessFile != null && !realPath.equals(this.lastRealPath)) {
                this.stop();
            }
            if (this.randomAccessFile == null) {
                this.lastRealPath = realPath;
                this.randomAccessFile = new RandomAccessFile(new File(realPath), "rw");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.fileChannel = this.randomAccessFile.getChannel();
        String str2 = event + "\n";
        long numBytes = str2.getBytes().length;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(str2.getBytes(Charset.forName("UTF-8")));
        try {
            this.randomAccessFile.seek(this.randomAccessFile.length());
            try (ReadableByteChannel inputChannel = Channels.newChannel(inputStream);){
                this.fileChannel.transferFrom(inputChannel, this.randomAccessFile.length(), numBytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void close() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object clone() {
        return null;
    }

    @Override
    public void stop() {
        try {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
                this.fileChannel.close();
            }
            this.randomAccessFile = null;
            this.fileChannel = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

