/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file.archive;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.audit4j.core.Initializable;
import org.audit4j.core.exception.Audit4jRuntimeException;
import org.audit4j.core.util.AuditUtil;

public abstract class AbstractArchiveJob
implements Initializable,
Serializable {
    protected Integer archiveDateDiff;
    protected String path;
    protected String archiveOptions;
    protected String compressionExtention;

    abstract void archive();

    protected File[] getAvailableFiles(String logFileLocation, final Date maxDate) {
        File dir = new File(logFileLocation);
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                boolean extentionMatch = fileName.endsWith(AbstractArchiveJob.this.compressionExtention);
                boolean dateMatch = maxDate.before(AbstractArchiveJob.this.fileCreatedDate(fileName));
                return dateMatch && extentionMatch;
            }
        });
    }

    private Date fileCreatedDate(String fileName) {
        String[] splittedWithoutExtention = fileName.split(".");
        String fileNameWithoutExtention = splittedWithoutExtention[0];
        String[] splittedWithoutPrefix = fileNameWithoutExtention.split("-");
        String fileNameDateInStr = splittedWithoutPrefix[1];
        try {
            return AuditUtil.stringTodate(fileNameDateInStr, "yyyy-MM-dd");
        }
        catch (ParseException e) {
            throw new Audit4jRuntimeException("Exception occured parsing the date.", e);
        }
    }

    public void setArchiveDateDiff(Integer archiveDateDiff) {
        this.archiveDateDiff = archiveDateDiff;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setArchiveOptions(String archiveOptions) {
        this.archiveOptions = archiveOptions;
    }

    public void setCompressionExtention(String compressionExtention) {
        this.compressionExtention = compressionExtention;
    }
}

