/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file.archive;

import java.util.List;
import org.audit4j.core.Initializable;
import org.audit4j.core.handler.file.archive.AbstractArchiveJob;
import org.audit4j.core.handler.file.archive.ArchiveEnv;
import org.audit4j.core.handler.file.archive.ArchiveMethod;
import org.audit4j.core.handler.file.archive.JobFactory;
import org.audit4j.core.schedule.CronTrigger;
import org.audit4j.core.schedule.Schedulers;
import org.audit4j.core.util.Log;

public class ArchiveManager
implements Initializable {
    private List<AbstractArchiveJob> jobs;
    private final ArchiveEnv archiveEnv;

    public ArchiveManager(ArchiveEnv archiveEnv) {
        this.archiveEnv = archiveEnv;
    }

    @Override
    public void init() {
        Log.info((Object)"Starting Archive Manager");
        if (this.archiveEnv.getArchiveMethod().equals((Object)ArchiveMethod.SIMPLE)) {
            this.executeArchive();
        } else if (this.archiveEnv.getArchiveMethod().equals((Object)ArchiveMethod.SCHEDULED)) {
            this.jobs = new JobFactory().getJobs(this.archiveEnv);
            Schedulers.taskRegistry().registor(new CronTrigger(this.archiveEnv.getCronPattern()), new Runnable(){

                @Override
                public void run() {
                    ArchiveManager.this.executeArchive();
                }
            });
        }
    }

    private void executeArchive() {
        for (AbstractArchiveJob archiveJob : this.jobs) {
            archiveJob.setArchiveDateDiff(this.extractArchiveDateCount(this.archiveEnv.getDatePattern()));
            archiveJob.setPath(this.archiveEnv.getDirPath());
            archiveJob.setCompressionExtention(this.archiveEnv.getCompression().getExtention());
            archiveJob.archive();
        }
    }

    public Integer extractArchiveDateCount(String datePattern) {
        int dateCount = 0;
        String[] splits = datePattern.split("d|M|y");
        if (splits.length > 0) {
            dateCount += Integer.valueOf(splits[0]).intValue();
        }
        if (splits.length > 1) {
            dateCount += Integer.valueOf(splits[1]) * 30;
        }
        if (splits.length > 2) {
            dateCount += Integer.valueOf(splits[2]) * 365;
        }
        return dateCount;
    }

    @Override
    public void stop() {
    }
}

