/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file.archive;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.handler.file.FileHandlerUtil;
import org.audit4j.core.handler.file.archive.AbstractArchiveJob;
import org.audit4j.core.util.Log;

public class FileArchiveJob
extends AbstractArchiveJob {
    byte[] buffer = new byte[1024];

    @Override
    public void archive() {
        Log.info((Object)"Starting local archiving...");
        String fileName = FileHandlerUtil.generateAuditFileName(FileHandlerUtil.substractDate(new Date(), this.archiveDateDiff));
        String archiveFileName = FileHandlerUtil.generateAuditArchiveFileName(FileHandlerUtil.substractDate(new Date(), this.archiveDateDiff));
        String filePath = FileHandlerUtil.generateOutputFilePath(this.path, fileName);
        String archivePath = FileHandlerUtil.generateOutputFilePath(this.path, archiveFileName);
        if (FileHandlerUtil.isFileAlreadyExists(filePath)) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(archivePath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry(fileName);
            try {
                int len;
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(filePath);
                while ((len = in.read(this.buffer)) > 0) {
                    zos.write(this.buffer, 0, len);
                }
                in.close();
                zos.closeEntry();
                zos.close();
                System.out.println("Done");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void init() throws InitializationException {
    }

    @Override
    public void stop() {
    }
}

