/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.handler.file.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.audit4j.core.exception.Audit4jRuntimeException;
import org.audit4j.core.handler.file.archive.Compressor;

public class ZIPCompressor
implements Compressor {
    byte[] buffer = new byte[1024];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void compress(InputStream in, OutputStream out, String targetName) {
        ZipOutputStream zos = new ZipOutputStream(out);
        ZipEntry ze = new ZipEntry(targetName);
        try {
            int len;
            zos.putNextEntry(ze);
            while ((len = in.read(this.buffer)) > 0) {
                zos.write(this.buffer, 0, len);
            }
            return;
        }
        catch (IOException e) {
            throw new Audit4jRuntimeException("Could not compress the given data", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new Audit4jRuntimeException("Could not compress the given data", e);
            }
            finally {
                try {
                    zos.closeEntry();
                }
                catch (IOException e) {
                    throw new Audit4jRuntimeException("Could not compress the given data", e);
                }
                finally {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        throw new Audit4jRuntimeException("Could not compress the given data", e);
                    }
                }
            }
        }
    }
}

