/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.io;

import java.lang.reflect.Method;
import org.audit4j.core.AnnotationTransformer;
import org.audit4j.core.dto.AnnotationAuditEvent;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.io.AuditOutputStream;
import reactor.core.Environment;
import reactor.core.composable.Deferred;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.DeferredStreamSpec;
import reactor.core.composable.spec.Streams;
import reactor.function.Consumer;
import reactor.function.support.Boundary;

public class AsyncAnnotationAuditOutputStream
implements AuditOutputStream<AnnotationAuditEvent> {
    AuditOutputStream<AuditEvent> outputStream;
    Deferred<AnnotationAuditEvent, Stream<AnnotationAuditEvent>> annotationDeferred = null;
    static Environment ENV;
    Boundary b = null;

    public AsyncAnnotationAuditOutputStream(final AuditOutputStream<AuditEvent> outputStream, final AnnotationTransformer transformer) {
        ENV = new Environment();
        this.outputStream = outputStream;
        this.b = new Boundary();
        this.annotationDeferred = (Deferred)((DeferredStreamSpec)((DeferredStreamSpec)Streams.defer().env(ENV)).dispatcher("ringBuffer")).get();
        Stream annostream = (Stream)this.annotationDeferred.compose();
        annostream.consume(this.b.bind((Consumer)new Consumer<AnnotationAuditEvent>(){

            public void accept(AnnotationAuditEvent annotationEvent) {
                Object event = transformer.transformToEvent(annotationEvent);
                if (event != null) {
                    outputStream.write(event);
                }
            }
        }));
    }

    public AsyncAnnotationAuditOutputStream write(AnnotationAuditEvent event) {
        this.annotationDeferred.accept((Object)event);
        this.b.await();
        return this;
    }

    public AsyncAnnotationAuditOutputStream write(Class<?> clazz, Method method, Object[] args) {
        AnnotationAuditEvent event = new AnnotationAuditEvent();
        event.setClazz(clazz);
        event.setMethod(method);
        event.setArgs(args);
        this.annotationDeferred.accept((Object)event);
        this.b.await();
        return this;
    }

    @Override
    public void close() {
        ENV.shutdown();
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public AuditOutputStream<AnnotationAuditEvent> writeBatch(EventBatch batch) {
        return null;
    }
}

